/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.cache.PassivationListener;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class MockSessionSpecificationProvider<C>
implements SessionSpecificationProvider<Map.Entry<ImmutableSession, C>, C>,
SessionEventListenerSpecificationProvider<Map.Entry<ImmutableSession, C>, PassivationListener<C>> {
    public Class<PassivationListener<C>> getEventListenerClass() {
        return PassivationListener.class;
    }

    public Consumer<Map.Entry<ImmutableSession, C>> preEvent(PassivationListener<C> listener) {
        return listener::passivated;
    }

    public Consumer<Map.Entry<ImmutableSession, C>> postEvent(PassivationListener<C> listener) {
        return listener::activated;
    }

    public PassivationListener<C> asEventListener(final Consumer<Map.Entry<ImmutableSession, C>> preEvent, final Consumer<Map.Entry<ImmutableSession, C>> postEvent) {
        return new PassivationListener<C>(){

            @Override
            public void passivated(Map.Entry<ImmutableSession, C> entry) {
                preEvent.accept(entry);
            }

            @Override
            public void activated(Map.Entry<ImmutableSession, C> entry) {
                postEvent.accept(entry);
            }
        };
    }

    public Map.Entry<ImmutableSession, C> asSession(ImmutableSession session, C context) {
        return Map.entry(session, context);
    }
}

