/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.logging.Logger;
import org.wildfly.clustering.server.cache.Cache;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.cache.CacheableSession;
import org.wildfly.clustering.session.cache.CachedSession;
import org.wildfly.clustering.session.cache.DecoratedSessionManager;
import org.wildfly.common.function.Functions;

public class CachedSessionManager<C>
extends DecoratedSessionManager<C> {
    static final Logger LOGGER = Logger.getLogger(CachedSessionManager.class);
    private final Cache<String, CompletionStage<CacheableSession<C>>> sessionCache;
    private final BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>> sessionCreator;
    private final BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>> sessionFinder;
    private final Function<CacheableSession<C>, Session<C>> identity = Functions.cast(Function.identity());

    public CachedSessionManager(final SessionManager<C> manager, CacheFactory cacheFactory) {
        super(manager);
        this.sessionCreator = new BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>>(){

            @Override
            public CompletionStage<CacheableSession<C>> apply(String id, Runnable closeTask) {
                return manager.createSessionAsync(id).thenApply(session -> new CachedSession(session, closeTask));
            }
        };
        final UnaryOperator validator = new UnaryOperator<Session<C>>(){

            @Override
            public Session<C> apply(Session<C> session) {
                if (session != null && !session.isValid()) {
                    try {
                        session.close();
                        return null;
                    }
                    catch (Throwable e) {
                        LOGGER.warn((Object)e.getLocalizedMessage(), e);
                    }
                }
                return session;
            }
        };
        this.sessionFinder = new BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>>(){

            @Override
            public CompletionStage<CacheableSession<C>> apply(String id, final Runnable closeTask) {
                Function wrapper = new Function<Session<C>, CacheableSession<C>>(){

                    @Override
                    public CacheableSession<C> apply(Session<C> session) {
                        return session != null ? new CachedSession(session, closeTask) : null;
                    }
                };
                CompletionStage result = manager.findSessionAsync(id).thenApply(validator).thenApply(wrapper);
                result.whenComplete(new BiConsumer<CacheableSession<C>, Throwable>(){

                    @Override
                    public void accept(CacheableSession<C> session, Throwable e) {
                        if (session == null) {
                            closeTask.run();
                        }
                    }
                });
                return result;
            }
        };
        this.sessionCache = cacheFactory.createCache(Functions.discardingConsumer(), new Consumer<CompletionStage<CacheableSession<C>>>(){

            @Override
            public void accept(CompletionStage<CacheableSession<C>> future) {
                try {
                    CacheableSession session = future.toCompletableFuture().join();
                    if (session != null) {
                        ((Session)session.get()).close();
                    }
                }
                catch (CancellationException session) {
                }
                catch (Throwable e) {
                    LOGGER.warn((Object)e.getLocalizedMessage(), e);
                }
            }
        });
    }

    @Override
    public CompletionStage<Session<C>> createSessionAsync(String id) {
        return ((CompletionStage)this.sessionCache.computeIfAbsent((Object)id, this.sessionCreator)).thenApply(this.identity);
    }

    @Override
    public CompletionStage<Session<C>> findSessionAsync(String id) {
        return ((CompletionStage)this.sessionCache.computeIfAbsent((Object)id, this.sessionFinder)).thenApply(this.identity);
    }
}

