/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.marshalling.Marshallability;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;

public class CoarseSessionAttributesTestCase {
    private final CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
    private final Marshallability marshallability = (Marshallability)Mockito.mock(Marshallability.class);
    private final Immutability immutability = (Immutability)Mockito.mock(Immutability.class);
    private final SessionActivationNotifier notifier = (SessionActivationNotifier)Mockito.mock(SessionActivationNotifier.class);

    @AfterEach
    public void resetMocks() {
        Mockito.reset((Object[])new Object[]{this.mutator, this.marshallability, this.immutability});
    }

    private SessionAttributes createSessionAttributes(Map<String, Object> map) {
        CoarseSessionAttributes attributes = new CoarseSessionAttributes(new TreeMap<String, Object>(map), this.mutator, this.marshallability, this.immutability, this.notifier);
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).postActivate();
        return attributes;
    }

    @Test
    public void removeAttribute() {
        UUID existing = UUID.randomUUID();
        try (SessionAttributes attributes = this.createSessionAttributes(Map.of("existing", existing));){
            Assertions.assertNull((Object)attributes.remove((Object)"missing"));
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        Mockito.reset((Object[])new SessionActivationNotifier[]{this.notifier});
        attributes = this.createSessionAttributes(Map.of("existing", existing));
        try {
            Assertions.assertNull((Object)attributes.remove((Object)"missing"));
            Assertions.assertSame((Object)existing, (Object)attributes.remove((Object)"existing"));
        }
        finally {
            if (attributes != null) {
                attributes.close();
            }
        }
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator)).mutate();
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
    }

    @Test
    public void setAttribute() {
        UUID existing = UUID.randomUUID();
        UUID unmarshallable = UUID.randomUUID();
        try (SessionAttributes attributes = this.createSessionAttributes(Map.of("existing", existing));){
            ((Marshallability)Mockito.doReturn((Object)false).when((Object)this.marshallability)).isMarshallable((Object)unmarshallable);
            Assertions.assertNull((Object)attributes.put((Object)"missing", null));
            Assertions.assertThrows(IllegalArgumentException.class, () -> attributes.put((Object)"unmarshallable", (Object)unmarshallable));
        }
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        Mockito.reset((Object[])new SessionActivationNotifier[]{this.notifier});
        UUID removing = UUID.randomUUID();
        UUID newIntermediate = UUID.randomUUID();
        UUID newReplacement = UUID.randomUUID();
        UUID existingIntermediate = UUID.randomUUID();
        UUID existingReplacement = UUID.randomUUID();
        try (SessionAttributes attributes = this.createSessionAttributes(Map.of("existing", existing, "removing", removing));){
            ((Marshallability)Mockito.doReturn((Object)true).when((Object)this.marshallability)).isMarshallable((Object)newIntermediate);
            ((Marshallability)Mockito.doReturn((Object)true).when((Object)this.marshallability)).isMarshallable((Object)newReplacement);
            ((Marshallability)Mockito.doReturn((Object)true).when((Object)this.marshallability)).isMarshallable((Object)existingIntermediate);
            ((Marshallability)Mockito.doReturn((Object)true).when((Object)this.marshallability)).isMarshallable((Object)existingReplacement);
            ((Marshallability)Mockito.doReturn((Object)false).when((Object)this.marshallability)).isMarshallable((Object)unmarshallable);
            Assertions.assertThrows(IllegalArgumentException.class, () -> attributes.put((Object)"unmarshallable", (Object)unmarshallable));
            Assertions.assertNull((Object)attributes.put((Object)"new", (Object)newIntermediate));
            Assertions.assertSame((Object)newIntermediate, (Object)attributes.put((Object)"new", (Object)newReplacement));
            Assertions.assertSame((Object)existing, (Object)attributes.put((Object)"existing", (Object)existingIntermediate));
            Assertions.assertSame((Object)existingIntermediate, (Object)attributes.put((Object)"existing", (Object)existingReplacement));
            Assertions.assertSame((Object)removing, (Object)attributes.put((Object)"removing", null));
        }
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator)).mutate();
    }

    @Test
    public void getAttributeNames() {
        UUID foo = UUID.randomUUID();
        UUID bar = UUID.randomUUID();
        Map<String, UUID> values = Map.of("foo", foo, "bar", bar);
        try (CoarseSessionAttributes attributes = new CoarseSessionAttributes(values, this.mutator, this.marshallability, this.immutability, this.notifier);){
            Set names = attributes.keySet();
            Assertions.assertEquals((int)2, (int)names.size());
            Assertions.assertTrue((boolean)names.contains("foo"));
            Assertions.assertTrue((boolean)names.contains("bar"));
            Assertions.assertFalse((boolean)names.contains("baz"));
            Assertions.assertThrows(UnsupportedOperationException.class, () -> names.add("baz"));
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
    }

    @Test
    public void getAttribute() {
        UUID mutable = UUID.randomUUID();
        UUID immutable = UUID.randomUUID();
        Map<String, Object> map = Map.of("mutable", mutable, "immutable", immutable);
        ((Immutability)Mockito.doReturn((Object)true).when((Object)this.immutability)).test((Object)immutable);
        ((Immutability)Mockito.doReturn((Object)false).when((Object)this.immutability)).test((Object)mutable);
        try (SessionAttributes attributes = this.createSessionAttributes(map);){
            Assertions.assertNull((Object)attributes.get((Object)"foo"));
            Assertions.assertSame((Object)immutable, (Object)attributes.get((Object)"immutable"));
        }
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        Mockito.reset((Object[])new SessionActivationNotifier[]{this.notifier});
        attributes = this.createSessionAttributes(map);
        try {
            Assertions.assertNull((Object)attributes.get((Object)"baz"));
            Assertions.assertSame((Object)immutable, (Object)attributes.get((Object)"immutable"));
            Assertions.assertSame((Object)mutable, (Object)attributes.get((Object)"mutable"));
        }
        finally {
            if (attributes != null) {
                attributes.close();
            }
        }
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator)).mutate();
    }
}

