/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.FineSessionMetaDataSerializationContextInitializer;

public class DefaultSessionAccessMetaDataEntryMarshallerTestCase {
    @Test
    public void test() {
        Tester tester = new ProtoStreamTesterFactory((SerializationContextInitializer)new FineSessionMetaDataSerializationContextInitializer()).createTester(DefaultSessionAccessMetaDataEntryMarshallerTestCase::assertEquals);
        DefaultSessionAccessMetaDataEntry metaData = new DefaultSessionAccessMetaDataEntry();
        metaData.setLastAccessDuration(Duration.ZERO, Duration.ofNanos(100000000L));
        tester.accept(metaData);
        metaData.setLastAccessDuration(Duration.ofSeconds(300L), Duration.ofNanos(100000000L));
        tester.accept(metaData);
        metaData.setLastAccessDuration(Duration.ofSeconds(300L), Duration.ofSeconds(1L, 100000000L));
        tester.accept(metaData);
    }

    static void assertEquals(DefaultSessionAccessMetaDataEntry metaData1, DefaultSessionAccessMetaDataEntry metaData2) {
        Assertions.assertEquals((Object)metaData1.getSinceCreationDuration(), (Object)metaData2.getSinceCreationDuration());
        Assertions.assertEquals((Object)metaData1.getLastAccessDuration(), (Object)metaData2.getLastAccessDuration());
    }
}

