/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class ImmutableSessionActivationNotifier<S, C, L>
implements SessionActivationNotifier {
    private final SessionSpecificationProvider<S, C> sessionProvider;
    private final SessionEventListenerSpecificationProvider<S, L> listenerProvider;
    private final ImmutableSession session;
    private final C context;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final Function<L, Consumer<S>> prePassivateFactory;
    private final Function<L, Consumer<S>> postActivateFactory;

    public ImmutableSessionActivationNotifier(SessionSpecificationProvider<S, C> sessionProvider, SessionEventListenerSpecificationProvider<S, L> listenerProvider, ImmutableSession session, C context) {
        this.sessionProvider = sessionProvider;
        this.listenerProvider = listenerProvider;
        this.session = session;
        this.context = context;
        this.prePassivateFactory = arg_0 -> listenerProvider.preEvent(arg_0);
        this.postActivateFactory = arg_0 -> listenerProvider.postEvent(arg_0);
    }

    @Override
    public void prePassivate() {
        if (this.active.compareAndSet(true, false)) {
            this.notify(this.prePassivateFactory);
        }
    }

    @Override
    public void postActivate() {
        if (this.active.compareAndSet(false, true)) {
            this.notify(this.postActivateFactory);
        }
    }

    private void notify(Function<L, Consumer<S>> factory) {
        List<Object> listeners = this.session.getAttributes().values().stream().map(arg_0 -> this.listenerProvider.asEventListener(arg_0)).filter(Optional::isPresent).map(Optional::get).toList();
        if (!listeners.isEmpty()) {
            Object session = this.sessionProvider.asSession(this.session, this.context);
            for (Object listener : listeners) {
                factory.apply(listener).accept(session);
            }
        }
    }
}

