/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.logging.Logger;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.server.cache.Cache;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.CacheableSession;
import org.wildfly.clustering.session.cache.CachedSession;
import org.wildfly.clustering.session.cache.DecoratedSessionManager;

public class CachedSessionManager<C>
extends DecoratedSessionManager<C> {
    static final Logger LOGGER = Logger.getLogger(CachedSessionManager.class);
    private final Cache<String, CompletionStage<CacheableSession<C>>> sessionCache;
    private final BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>> sessionCreator;
    private final BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>> sessionFinder;
    private final UnaryOperator<Session<C>> validator = new UnaryOperator<Session<C>>(){

        @Override
        public Session<C> apply(Session<C> session) {
            if (!session.isValid()) {
                try {
                    session.close();
                    return null;
                }
                catch (Throwable e) {
                    LOGGER.warn((Object)e.getLocalizedMessage(), e);
                }
            }
            return session;
        }
    };

    public CachedSessionManager(final SessionManager<C> manager, CacheFactory cacheFactory) {
        super(manager);
        this.sessionCreator = new BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>>(){

            @Override
            public CompletionStage<CacheableSession<C>> apply(String id, Runnable closeTask) {
                return manager.createSessionAsync(id).thenApply(session -> new CachedSession(session, closeTask));
            }
        };
        final Session missingSession = new Session<C>(){

            public String getId() {
                return null;
            }

            public boolean isValid() {
                return false;
            }

            public Map<String, Object> getAttributes() {
                return Map.of();
            }

            public SessionMetaData getMetaData() {
                return null;
            }

            public void invalidate() {
            }

            public C getContext() {
                return null;
            }

            public void close() {
            }
        };
        this.sessionFinder = new BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>>(){

            @Override
            public CompletionStage<CacheableSession<C>> apply(String id, final Runnable closeTask) {
                Function wrapper = new Function<Session<C>, CacheableSession<C>>(){

                    public CacheableSession<C> apply(Session<C> session) {
                        return new CachedSession(session, closeTask);
                    }
                };
                return manager.findSessionAsync(id).thenApply(wrapper.withDefault(Objects::nonNull, (Supplier)org.wildfly.clustering.function.Supplier.of((Object)missingSession)));
            }
        };
        this.sessionCache = cacheFactory.createCache((java.util.function.Consumer)Consumer.empty(), (java.util.function.Consumer)new Consumer<CompletionStage<CacheableSession<C>>>(){

            public void accept(CompletionStage<CacheableSession<C>> future) {
                try {
                    CacheableSession session = future.toCompletableFuture().join();
                    if (session != null) {
                        ((Session)session.get()).close();
                    }
                }
                catch (CancellationException session) {
                }
                catch (Throwable e) {
                    LOGGER.warn((Object)e.getLocalizedMessage(), e);
                }
            }
        });
    }

    @Override
    public CompletionStage<Session<C>> createSessionAsync(String id) {
        return ((CompletionStage)this.sessionCache.computeIfAbsent((Object)id, this.sessionCreator)).thenApply(Function.identity());
    }

    @Override
    public CompletionStage<Session<C>> findSessionAsync(String id) {
        return ((CompletionStage)this.sessionCache.computeIfAbsent((Object)id, this.sessionFinder)).thenApply(this.validator);
    }
}

