/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.marshalling.Marshallability;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;

public class CoarseSessionAttributesTestCase {
    private final CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
    private final Marshallability marshallability = (Marshallability)Mockito.mock(Marshallability.class);
    private final Immutability immutability = (Immutability)Mockito.mock(Immutability.class);
    private final SessionActivationNotifier notifier = (SessionActivationNotifier)Mockito.mock(SessionActivationNotifier.class);

    @AfterEach
    public void resetMocks() {
        Mockito.reset((Object[])new Object[]{this.mutator, this.marshallability, this.immutability});
    }

    private SessionAttributes createSessionAttributes(Map<String, Object> map) {
        CoarseSessionAttributes attributes = new CoarseSessionAttributes(new TreeMap<String, Object>(map), this.mutator, this.marshallability, this.immutability, this.notifier);
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).postActivate();
        return attributes;
    }

    @Test
    public void removeAttribute() {
        UUID existing = UUID.randomUUID();
        try (SessionAttributes attributes = this.createSessionAttributes(Map.of("existing", existing));){
            Assertions.assertThat((Object)attributes.remove((Object)"missing")).isNull();
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        Mockito.reset((Object[])new SessionActivationNotifier[]{this.notifier});
        attributes = this.createSessionAttributes(Map.of("existing", existing));
        try {
            Assertions.assertThat((Object)attributes.remove((Object)"missing")).isNull();
            Assertions.assertThat((Object)attributes.remove((Object)"existing")).isSameAs((Object)existing);
        }
        finally {
            if (attributes != null) {
                attributes.close();
            }
        }
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator)).mutate();
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
    }

    @Test
    public void setAttribute() {
        UUID existing = UUID.randomUUID();
        UUID unmarshallable = UUID.randomUUID();
        try (SessionAttributes attributes = this.createSessionAttributes(Map.of("existing", existing));){
            ((Marshallability)Mockito.doReturn((Object)false).when((Object)this.marshallability)).isMarshallable((Object)unmarshallable);
            Assertions.assertThat((Object)attributes.put((Object)"missing", null)).isNull();
            Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> attributes.put((Object)"unmarshallable", (Object)unmarshallable));
        }
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        Mockito.reset((Object[])new SessionActivationNotifier[]{this.notifier});
        UUID removing = UUID.randomUUID();
        UUID newIntermediate = UUID.randomUUID();
        UUID newReplacement = UUID.randomUUID();
        UUID existingIntermediate = UUID.randomUUID();
        UUID existingReplacement = UUID.randomUUID();
        try (SessionAttributes attributes = this.createSessionAttributes(Map.of("existing", existing, "removing", removing));){
            ((Marshallability)Mockito.doReturn((Object)true).when((Object)this.marshallability)).isMarshallable((Object)newIntermediate);
            ((Marshallability)Mockito.doReturn((Object)true).when((Object)this.marshallability)).isMarshallable((Object)newReplacement);
            ((Marshallability)Mockito.doReturn((Object)true).when((Object)this.marshallability)).isMarshallable((Object)existingIntermediate);
            ((Marshallability)Mockito.doReturn((Object)true).when((Object)this.marshallability)).isMarshallable((Object)existingReplacement);
            ((Marshallability)Mockito.doReturn((Object)false).when((Object)this.marshallability)).isMarshallable((Object)unmarshallable);
            Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> attributes.put((Object)"unmarshallable", (Object)unmarshallable));
            Assertions.assertThat((Object)attributes.put((Object)"new", (Object)newIntermediate)).isNull();
            Assertions.assertThat((Object)attributes.put((Object)"new", (Object)newReplacement)).isSameAs((Object)newIntermediate);
            Assertions.assertThat((Object)attributes.put((Object)"existing", (Object)existingIntermediate)).isSameAs((Object)existing);
            Assertions.assertThat((Object)attributes.put((Object)"existing", (Object)existingReplacement)).isSameAs((Object)existingIntermediate);
            Assertions.assertThat((Object)attributes.put((Object)"removing", null)).isSameAs((Object)removing);
        }
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator)).mutate();
    }

    @Test
    public void getAttributeNames() {
        UUID foo = UUID.randomUUID();
        UUID bar = UUID.randomUUID();
        Map<String, UUID> values = Map.of("foo", foo, "bar", bar);
        try (CoarseSessionAttributes attributes = new CoarseSessionAttributes(values, this.mutator, this.marshallability, this.immutability, this.notifier);){
            Set names = attributes.keySet();
            Assertions.assertThat((Collection)names).containsExactlyInAnyOrderElementsOf(values.keySet());
            Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> names.add("baz"));
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
    }

    @Test
    public void getAttribute() {
        UUID mutable = UUID.randomUUID();
        UUID immutable = UUID.randomUUID();
        Map<String, Object> map = Map.of("mutable", mutable, "immutable", immutable);
        ((Immutability)Mockito.doReturn((Object)true).when((Object)this.immutability)).test((Object)immutable);
        ((Immutability)Mockito.doReturn((Object)false).when((Object)this.immutability)).test((Object)mutable);
        try (SessionAttributes attributes = this.createSessionAttributes(map);){
            Assertions.assertThat((Object)attributes.get((Object)"foo")).isNull();
            Assertions.assertThat((Object)attributes.get((Object)"immutable")).isSameAs((Object)immutable);
        }
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        Mockito.reset((Object[])new SessionActivationNotifier[]{this.notifier});
        attributes = this.createSessionAttributes(map);
        try {
            Assertions.assertThat((Object)attributes.get((Object)"baz")).isNull();
            Assertions.assertThat((Object)attributes.get((Object)"immutable")).isSameAs((Object)immutable);
            Assertions.assertThat((Object)attributes.get((Object)"mutable")).isSameAs((Object)mutable);
        }
        finally {
            if (attributes != null) {
                attributes.close();
            }
        }
        ((SessionActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate();
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator)).mutate();
    }
}

