/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.cache.CacheConfiguration;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.server.expiration.Expiration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.AttachedSession;
import org.wildfly.clustering.session.cache.DetachedSession;
import org.wildfly.clustering.session.cache.ManagedSession;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.SimpleImmutableSession;

public abstract class AbstractSessionManager<C, MV, AV, SC>
implements SessionManager<SC>,
SessionStatistics {
    protected final System.Logger logger = System.getLogger(this.getClass().getName());
    private final Supplier<SessionManager<SC>> manager;
    private final SessionFactory<C, MV, AV, SC> factory;
    private final Consumer<ImmutableSession> expirationListener;
    private final Expiration expiration;
    private final Supplier<String> identifierFactory;
    private final C context;
    private final Supplier<Batch> batchFactory;
    private final UnaryOperator<Session<SC>> wrapper;

    protected AbstractSessionManager(final Supplier<SessionManager<SC>> manager, SessionManagerConfiguration<C> configuration, CacheConfiguration cacheConfiguration, SessionFactory<C, MV, AV, SC> factory, final Consumer<ImmutableSession> sessionCloseTask) {
        this.manager = manager;
        this.identifierFactory = configuration.getIdentifierFactory();
        this.context = configuration.getContext();
        this.batchFactory = cacheConfiguration.getBatchFactory();
        this.expiration = configuration;
        this.expirationListener = configuration.getExpirationListener();
        this.factory = factory;
        this.wrapper = new UnaryOperator<Session<SC>>(){

            @Override
            public Session<SC> apply(Session<SC> session) {
                return new ManagedSession<Object>(new AttachedSession(session, sessionCloseTask), new DetachedSession<Object>((SessionManager)manager.get(), session.getId(), session.getContext()));
            }
        };
    }

    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Supplier<Batch> getBatchFactory() {
        return this.batchFactory;
    }

    public CompletionStage<Session<SC>> createSessionAsync(String id) {
        this.logger.log(System.Logger.Level.TRACE, "Creating session {0}", id);
        return this.factory.createValueAsync(id, this.expiration.getTimeout()).thenApply(entry -> (Session)this.wrapper.apply(this.factory.createSession(id, (Map.Entry<MV, AV>)entry, this.context)));
    }

    public CompletionStage<Session<SC>> findSessionAsync(String id) {
        this.logger.log(System.Logger.Level.TRACE, "Locating session {0}", id);
        return this.factory.findValueAsync(id).thenApply(entry -> {
            if (entry == null) {
                this.logger.log(System.Logger.Level.TRACE, "Session {0} not found", id);
                return null;
            }
            ImmutableSession session = this.factory.createImmutableSession(id, (Map.Entry<MV, AV>)entry);
            if (session.getMetaData().isExpired()) {
                this.logger.log(System.Logger.Level.TRACE, "Session {0} was found, but has expired", id);
                this.expirationListener.accept(session);
                this.factory.removeAsync(id);
                return null;
            }
            return (Session)this.wrapper.apply(this.factory.createSession(id, (Map.Entry<MV, AV>)entry, this.context));
        });
    }

    public CompletionStage<ImmutableSession> findImmutableSessionAsync(String id) {
        return this.factory.findValueAsync(id).thenApply(entry -> entry != null ? new SimpleImmutableSession(this.factory.createImmutableSession(id, (Map.Entry<MV, AV>)entry)) : null);
    }

    public Session<SC> getDetachedSession(String id) {
        return new DetachedSession<SC>(this.manager.get(), id, this.factory.getContextFactory().get());
    }

    public SessionStatistics getStatistics() {
        return this;
    }
}

