/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.util.UUID;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.server.offset.OffsetValue;
import org.wildfly.clustering.server.offset.Value;
import org.wildfly.clustering.session.cache.metadata.fine.AbstractSessionCreationMetaDataEntryTestCase;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntryFunction;

public class SessionCreationMetaDataEntryFunctionTestCase
extends AbstractSessionCreationMetaDataEntryTestCase {
    @Override
    public void accept(SessionCreationMetaDataEntry<Object> entry) {
        UUID context = UUID.randomUUID();
        Assertions.assertThat((Object)entry.getContext().get((Supplier)org.wildfly.clustering.function.Supplier.of((Object)context))).isSameAs((Object)context);
        Assertions.assertThat((Object)entry.getContext().get((Supplier)org.wildfly.clustering.function.Supplier.of(null))).isSameAs((Object)context);
        OffsetValue timeoutOffset = OffsetValue.from((Duration)entry.getTimeout());
        MutableSessionCreationMetaData mutableEntry = new MutableSessionCreationMetaData(entry, (Value)timeoutOffset);
        this.updateState((SessionCreationMetaData)mutableEntry);
        this.verifyOriginalState((SessionCreationMetaData)entry);
        Key key = (Key)Mockito.mock(Key.class);
        SessionCreationMetaDataEntry resultEntry = (SessionCreationMetaDataEntry)new SessionCreationMetaDataEntryFunction(timeoutOffset).apply((Object)key, entry);
        Mockito.verifyNoInteractions((Object[])new Object[]{key});
        this.verifyUpdatedState((SessionCreationMetaData)resultEntry);
        Assertions.assertThat((Object)resultEntry.getContext().get((Supplier)org.wildfly.clustering.function.Supplier.of(null))).isSameAs((Object)context);
    }
}

