/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.function.Supplier;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.server.util.Supplied;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.CompositeImmutableSession;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;

public class CompositeSession<C>
extends CompositeImmutableSession
implements Session<C> {
    private static final System.Logger LOGGER = System.getLogger(CompositeSession.class.getName());
    private final InvalidatableSessionMetaData metaData;
    private final SessionAttributes attributes;
    private final Supplied<C> context;
    private final Supplier<C> contextFactory;
    private final CacheEntryRemover<String> remover;

    public CompositeSession(String id, InvalidatableSessionMetaData metaData, SessionAttributes attributes, Supplied<C> context, Supplier<C> contextFactory, CacheEntryRemover<String> remover) {
        super(id, (ImmutableSessionMetaData)metaData, attributes);
        this.metaData = metaData;
        this.attributes = attributes;
        this.context = context;
        this.contextFactory = contextFactory;
        this.remover = remover;
    }

    public SessionAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isValid() {
        return this.metaData.isValid();
    }

    public void invalidate() {
        if (this.metaData.invalidate()) {
            LOGGER.log(System.Logger.Level.DEBUG, "Invalidating session {0}", this.getId());
            this.remover.remove((Object)this.getId());
        }
    }

    public SessionMetaData getMetaData() {
        return this.metaData;
    }

    public void close() {
        if (this.metaData.isValid()) {
            LOGGER.log(System.Logger.Level.TRACE, "Closing session {0}", this.getId());
            this.attributes.close();
            this.metaData.close();
        }
    }

    public C getContext() {
        return (C)this.context.get(this.contextFactory);
    }
}

