/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.session.cache.user.MutableUserSessions;

public class MutableUserSessionsTestCase {
    @Test
    public void getApplications() {
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        MutableUserSessions sessions = new MutableUserSessions(Map.of("deployment", "session"), mutator);
        Set result = sessions.getDeployments();
        Assertions.assertThat((Collection)result).containsExactly((Object[])new String[]{"deployment"});
        ((Runnable)Mockito.verify((Object)mutator, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void getSession() {
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        MutableUserSessions sessions = new MutableUserSessions(Map.of("deployment", "session"), mutator);
        Assertions.assertThat((String)((String)sessions.getSession((Object)"deployment"))).isEqualTo("session");
        Assertions.assertThat((String)((String)sessions.getSession((Object)"foo"))).isNull();
        ((Runnable)Mockito.verify((Object)mutator, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void addSession() {
        TreeMap deployments = new TreeMap();
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        MutableUserSessions sessions = new MutableUserSessions(deployments, mutator);
        sessions.addSession((Object)"deployment", (Object)"session");
        ((Runnable)Mockito.verify((Object)mutator)).run();
        sessions.addSession((Object)"deployment", (Object)"session");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
    }

    @Test
    public void removeSession() {
        TreeMap<String, String> deployments = new TreeMap<String, String>(Map.of("deployment", "session"));
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        MutableUserSessions sessions = new MutableUserSessions(deployments, mutator);
        sessions.removeSession((Object)"deployment");
        ((Runnable)Mockito.verify((Object)mutator)).run();
        sessions.removeSession((Object)"deployment");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
    }
}

