/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.fine;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.fine.FineSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;

public class FineSessionAttributesTestCase {
    private final String id = "id";
    private final CacheEntryMutatorFactory<String, Map<String, Object>> mutatorFactory = (CacheEntryMutatorFactory)Mockito.mock(CacheEntryMutatorFactory.class);
    private final Marshaller<Object, Object> marshaller = (Marshaller)Mockito.mock(Marshaller.class);
    private final Immutability immutability = (Immutability)Mockito.mock(Immutability.class);
    private final CacheProperties properties = (CacheProperties)Mockito.mock(CacheProperties.class);
    private final SessionAttributeActivationNotifier notifier = (SessionAttributeActivationNotifier)Mockito.mock(SessionAttributeActivationNotifier.class);

    private SessionAttributes createSessionAttributes(String id, Map<String, Object> map) {
        ((CacheProperties)Mockito.doReturn((Object)true).when((Object)this.properties)).isMarshalling();
        FineSessionAttributes attribute = new FineSessionAttributes((Object)this.id, new TreeMap<String, Object>(map), this.mutatorFactory, this.marshaller, this.immutability, this.properties, this.notifier);
        for (Object value : map.values()) {
            ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).postActivate(value);
        }
        return attribute;
    }

    @AfterEach
    public void resetMocks() {
        Mockito.reset((Object[])new Object[]{this.mutatorFactory, this.marshaller, this.immutability, this.properties, this.notifier});
    }

    @Test
    public void getAttributeNames() {
        Map<String, Object> map = Map.of("foo", UUID.randomUUID(), "bar", UUID.randomUUID());
        try (SessionAttributes attributes = this.createSessionAttributes("id", map);){
            Assertions.assertThat((Collection)attributes.keySet()).containsExactlyInAnyOrderElementsOf(map.keySet());
        }
        for (Object value : map.values()) {
            ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate(value);
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.properties});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.marshaller});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutatorFactory});
    }

    @Test
    public void getAttribute() throws IOException {
        UUID mutable = UUID.randomUUID();
        UUID immutable = UUID.randomUUID();
        Map<String, Object> map = Map.of("mutable", mutable, "immutable", immutable);
        ((Immutability)Mockito.doReturn((Object)true).when((Object)this.immutability)).test((Object)immutable);
        ((Immutability)Mockito.doReturn((Object)false).when((Object)this.immutability)).test((Object)mutable);
        try (SessionAttributes attributes = this.createSessionAttributes("id", map);){
            Assertions.assertThat((Object)attributes.get((Object)"missing")).isNull();
            Assertions.assertThat((Object)attributes.get((Object)"immutable")).isSameAs((Object)immutable);
        }
        for (Object e : map.values()) {
            ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate(e);
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutatorFactory});
        Mockito.reset((Object[])new SessionAttributeActivationNotifier[]{this.notifier});
        UUID marshalledMutable = UUID.randomUUID();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.captor((Object[])new Map[0]);
        CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
        try (SessionAttributes attributes = this.createSessionAttributes("id", map);){
            Assertions.assertThat((Object)attributes.get((Object)"missing")).isNull();
            ((Marshaller)Mockito.doReturn((Object)marshalledMutable).when(this.marshaller)).write((Object)mutable);
            ((CacheEntryMutatorFactory)Mockito.doReturn((Object)mutator).when(this.mutatorFactory)).createMutator((Object)((String)Mockito.eq((Object)"id")), (Object)((Map)argumentCaptor.capture()));
            Assertions.assertThat((Object)attributes.get((Object)"immutable")).isSameAs((Object)immutable);
            Assertions.assertThat((Object)attributes.get((Object)"mutable")).isSameAs((Object)mutable);
        }
        for (Object e : map.values()) {
            ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate(e);
        }
        ((CacheEntryMutator)Mockito.verify((Object)mutator)).run();
        Map updates = (Map)argumentCaptor.getValue();
        Assertions.assertThat(updates.keySet()).containsExactly((Object[])new String[]{"mutable"});
        Assertions.assertThat(updates.get("mutable")).isSameAs((Object)marshalledMutable);
    }

    @Test
    public void removeAttribute() {
        UUID foo = UUID.randomUUID();
        UUID bar = UUID.randomUUID();
        try (SessionAttributes attributes = this.createSessionAttributes("id", Map.of("foo", foo, "bar", bar));){
            Assertions.assertThat((Object)attributes.remove((Object)"baz")).isNull();
        }
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate((Object)foo);
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate((Object)bar);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutatorFactory});
        Mockito.reset((Object[])new SessionAttributeActivationNotifier[]{this.notifier});
        ArgumentCaptor capturedUpdates = ArgumentCaptor.captor((Object[])new Map[0]);
        CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
        try (SessionAttributes attributes = this.createSessionAttributes("id", Map.of("foo", foo, "bar", bar));){
            Assertions.assertThat((Object)attributes.remove((Object)"baz")).isNull();
            ((CacheEntryMutatorFactory)Mockito.doReturn((Object)mutator).when(this.mutatorFactory)).createMutator((Object)((String)Mockito.eq((Object)"id")), (Object)((Map)capturedUpdates.capture()));
            Assertions.assertThat((Object)attributes.remove((Object)"foo")).isSameAs((Object)foo);
        }
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate((Object)bar);
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).prePassivate((Object)foo);
        ((CacheEntryMutator)Mockito.verify((Object)mutator)).run();
        Map updates = (Map)capturedUpdates.getValue();
        Assertions.assertThat(updates.keySet()).containsExactly((Object[])new String[]{"foo"});
        Assertions.assertThat(updates.get("foo")).isNull();
    }

    @Test
    public void setAttribute() throws IOException {
        UUID existing = UUID.randomUUID();
        UUID unmarshallable = UUID.randomUUID();
        try (SessionAttributes attributes = this.createSessionAttributes("id", Map.of("existing", existing));){
            ((Marshaller)Mockito.doReturn((Object)false).when(this.marshaller)).isMarshallable((Object)unmarshallable);
            Assertions.assertThat((Object)attributes.put((Object)"missing", null)).isNull();
            Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> attributes.put((Object)"unmarshallable", (Object)unmarshallable));
        }
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate((Object)existing);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutatorFactory});
        Mockito.reset((Object[])new SessionAttributeActivationNotifier[]{this.notifier});
        UUID removing = UUID.randomUUID();
        UUID newIntermediate = UUID.randomUUID();
        UUID newReplacement = UUID.randomUUID();
        UUID existingIntermediate = UUID.randomUUID();
        UUID existingReplacement = UUID.randomUUID();
        UUID marshalledNewReplacement = UUID.randomUUID();
        UUID marshalledExistingReplacement = UUID.randomUUID();
        ArgumentCaptor capturedUpdates = ArgumentCaptor.captor((Object[])new Map[0]);
        CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
        try (SessionAttributes attributes = this.createSessionAttributes("id", Map.of("existing", existing, "removing", removing));){
            ((Marshaller)Mockito.doReturn((Object)true).when(this.marshaller)).isMarshallable((Object)newIntermediate);
            ((Marshaller)Mockito.doReturn((Object)true).when(this.marshaller)).isMarshallable((Object)newReplacement);
            ((Marshaller)Mockito.doReturn((Object)true).when(this.marshaller)).isMarshallable((Object)existingIntermediate);
            ((Marshaller)Mockito.doReturn((Object)true).when(this.marshaller)).isMarshallable((Object)existingReplacement);
            ((CacheEntryMutatorFactory)Mockito.doReturn((Object)mutator).when(this.mutatorFactory)).createMutator((Object)((String)Mockito.eq((Object)"id")), (Object)((Map)capturedUpdates.capture()));
            ((Marshaller)Mockito.doReturn((Object)marshalledNewReplacement).when(this.marshaller)).write((Object)newReplacement);
            ((Marshaller)Mockito.doReturn((Object)marshalledExistingReplacement).when(this.marshaller)).write((Object)existingReplacement);
            Assertions.assertThat((Object)attributes.put((Object)"new", (Object)newIntermediate)).isNull();
            Assertions.assertThat((Object)attributes.put((Object)"new", (Object)newReplacement)).isSameAs((Object)newIntermediate);
            Assertions.assertThat((Object)attributes.put((Object)"existing", (Object)existingIntermediate)).isSameAs((Object)existing);
            Assertions.assertThat((Object)attributes.put((Object)"existing", (Object)existingReplacement)).isSameAs((Object)existingIntermediate);
            Assertions.assertThat((Object)attributes.put((Object)"removing", null)).isSameAs((Object)removing);
        }
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate((Object)newReplacement);
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier)).prePassivate((Object)existingReplacement);
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).prePassivate((Object)newIntermediate);
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).prePassivate((Object)existing);
        ((SessionAttributeActivationNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).prePassivate((Object)existingIntermediate);
        Map updates = (Map)capturedUpdates.getValue();
        Assertions.assertThat(updates.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"new", "existing", "removing"});
        Assertions.assertThat(updates.get("new")).isSameAs((Object)marshalledNewReplacement);
        Assertions.assertThat(updates.get("existing")).isSameAs((Object)marshalledExistingReplacement);
        Assertions.assertThat(updates.get("removing")).isNull();
    }
}

