/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.session.cache.user.MutableUserSessions;

public class MutableUserSessionsTestCase {
    @Test
    public void getApplications() {
        UUID key = UUID.randomUUID();
        CacheEntryMutatorFactory mutatorFactory = (CacheEntryMutatorFactory)Mockito.mock(CacheEntryMutatorFactory.class);
        Map<String, String> deployments = Map.of("deployment1", "session1", "deployment2", "session2");
        try (MutableUserSessions sessions = new MutableUserSessions((Object)key, deployments, mutatorFactory);){
            Assertions.assertThat((Collection)sessions.getDeployments()).containsExactlyInAnyOrder((Object[])new String[]{"deployment1", "deployment2"});
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{mutatorFactory});
    }

    @Test
    public void getSession() {
        UUID key = UUID.randomUUID();
        CacheEntryMutatorFactory mutatorFactory = (CacheEntryMutatorFactory)Mockito.mock(CacheEntryMutatorFactory.class);
        Map<String, String> deployments = Map.of("deployment1", "session1", "deployment2", "session2");
        try (MutableUserSessions sessions = new MutableUserSessions((Object)key, deployments, mutatorFactory);){
            Assertions.assertThat((String)((String)sessions.getSession((Object)"deployment1"))).isEqualTo("session1");
            Assertions.assertThat((String)((String)sessions.getSession((Object)"deployment2"))).isEqualTo("session2");
            Assertions.assertThat((String)((String)sessions.getSession((Object)"foo"))).isNull();
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{mutatorFactory});
    }

    @Test
    public void addSession() {
        UUID key = UUID.randomUUID();
        CacheEntryMutatorFactory mutatorFactory = (CacheEntryMutatorFactory)Mockito.mock(CacheEntryMutatorFactory.class);
        CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
        ((CacheEntryMutatorFactory)Mockito.doReturn((Object)mutator).when((Object)mutatorFactory)).createMutator((Object)key, Map.of("deployment2", "session2"));
        TreeMap<String, String> deployments = new TreeMap<String, String>();
        deployments.put("deployment1", "session1");
        try (MutableUserSessions sessions = new MutableUserSessions((Object)key, deployments, mutatorFactory);){
            Assertions.assertThat((boolean)sessions.addSession((Object)"deployment1", (Object)"session3")).isFalse();
            Assertions.assertThat((boolean)sessions.addSession((Object)"deployment2", (Object)"session2")).isTrue();
            Mockito.verifyNoInteractions((Object[])new Object[]{mutatorFactory});
        }
        ((CacheEntryMutator)Mockito.verify((Object)mutator)).run();
    }

    @Test
    public void removeSession() {
        UUID key = UUID.randomUUID();
        CacheEntryMutatorFactory mutatorFactory = (CacheEntryMutatorFactory)Mockito.mock(CacheEntryMutatorFactory.class);
        CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
        TreeMap<String, Object> updates = new TreeMap<String, Object>();
        updates.put("deployment1", null);
        ((CacheEntryMutatorFactory)Mockito.doReturn((Object)mutator).when((Object)mutatorFactory)).createMutator((Object)key, updates);
        TreeMap<String, String> deployments = new TreeMap<String, String>();
        deployments.put("deployment1", "session1");
        deployments.put("deployment2", "session2");
        try (MutableUserSessions sessions = new MutableUserSessions((Object)key, deployments, mutatorFactory);){
            Assertions.assertThat((String)((String)sessions.removeSession((Object)"deployment1"))).isEqualTo("session1");
            Assertions.assertThat((String)((String)sessions.removeSession((Object)"deployment3"))).isNull();
            Mockito.verifyNoInteractions((Object[])new Object[]{mutatorFactory});
        }
        ((CacheEntryMutator)Mockito.verify((Object)mutator)).run();
    }
}

