/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.cache.Cache;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.session.cache.user.CacheableUser;
import org.wildfly.clustering.session.cache.user.CachedUser;
import org.wildfly.clustering.session.cache.user.DecoratedUserManager;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserManager;

public class CachedUserManager<C, T, D, S>
extends DecoratedUserManager<C, T, D, S> {
    static final System.Logger LOGGER = System.getLogger(CachedUserManager.class.getName());
    private final Cache<String, CacheableUser<C, T, D, S>> cache;
    private final BiFunction<String, Runnable, CacheableUser<C, T, D, S>> finder;

    public CachedUserManager(final UserManager<C, T, D, S> manager, CacheFactory cacheFactory) {
        super(manager);
        this.finder = new BiFunction<String, Runnable, CacheableUser<C, T, D, S>>(){

            @Override
            public CacheableUser<C, T, D, S> apply(String id, Runnable closeTask) {
                User user = manager.findUser(id);
                return user != null ? new CachedUser(user, closeTask) : null;
            }
        };
        this.cache = cacheFactory.createCache((java.util.function.Consumer)Consumer.empty(), (java.util.function.Consumer)Consumer.close().compose(Supplier::get));
    }

    @Override
    public User<C, T, D, S> createUser(String id, final C context) {
        BiFunction creator = new BiFunction<String, Runnable, CacheableUser<C, T, D, S>>(){

            @Override
            public CacheableUser<C, T, D, S> apply(String id, Runnable closeTask) {
                return new CachedUser(CachedUserManager.super.createUser(id, context), closeTask);
            }
        };
        return (User)this.cache.computeIfAbsent((Object)id, creator);
    }

    @Override
    public User<C, T, D, S> findUser(String id) {
        return (User)this.cache.computeIfAbsent((Object)id, this.finder);
    }
}

