/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Map;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.manager.IdentifierFactory;
import org.wildfly.clustering.session.cache.user.UserFactory;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserManager;

public class DefaultUserManager<CV, C, T, SV, D, S>
implements UserManager<C, T, D, S> {
    private final UserFactory<CV, C, T, SV, D, S> factory;
    private final Supplier<Batch> batchFactory;
    private final IdentifierFactory<String> identifierFactory;

    public DefaultUserManager(UserFactory<CV, C, T, SV, D, S> factory, IdentifierFactory<String> identifierFactory, Supplier<Batch> batchFactory) {
        this.factory = factory;
        this.batchFactory = batchFactory;
        this.identifierFactory = identifierFactory;
    }

    public User<C, T, D, S> createUser(String id, C context) {
        Map.Entry value = (Map.Entry)this.factory.createValue(id, context);
        return this.factory.createUser(id, value);
    }

    public User<C, T, D, S> findUser(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue(id);
        return value != null ? this.factory.createUser(id, value) : null;
    }

    public Supplier<Batch> getBatchFactory() {
        return this.batchFactory;
    }

    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public boolean isStarted() {
        return this.identifierFactory.isStarted();
    }

    public void start() {
        this.identifierFactory.start();
    }

    public void stop() {
        this.identifierFactory.stop();
    }
}

