/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.Set;
import java.util.function.Consumer;
import org.wildfly.clustering.cache.CacheConfiguration;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.cache.AbstractSessionManager;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerConfiguration;
import org.wildfly.common.function.Functions;

public class HotRodSessionManager<SC, MV, AV, LC>
extends AbstractSessionManager<SC, MV, AV, LC, TransactionBatch> {
    private final Registrar<Consumer<ImmutableSession>> expirationListenerRegistrar;
    private final Consumer<ImmutableSession> expirationListener;
    private final Batcher<TransactionBatch> batcher;
    private volatile Registration expirationListenerRegistration;

    public HotRodSessionManager(SessionManagerConfiguration<SC> configuration, SessionFactory<SC, MV, AV, LC> factory, HotRodSessionManagerConfiguration hotrod) {
        super(configuration, (CacheConfiguration)hotrod, factory, Functions.discardingConsumer());
        this.expirationListenerRegistrar = hotrod.getExpirationListenerRegistrar();
        this.expirationListener = configuration.getExpirationListener();
        this.batcher = hotrod.getBatcher();
    }

    public void start() {
        this.expirationListenerRegistration = this.expirationListenerRegistrar.register(this.expirationListener);
    }

    public void stop() {
        if (this.expirationListenerRegistration != null) {
            this.expirationListenerRegistration.close();
        }
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public Set<String> getActiveSessions() {
        return Set.of();
    }

    public Set<String> getSessions() {
        return Set.of();
    }
}

