/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.remote.InfinispanServerExtension;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheContainerConfigurator;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManagerITCase;
import org.wildfly.clustering.session.SessionManagerParameters;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactoryProvider;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerParameters;

public class HotRodSessionManagerITCase
extends SessionManagerITCase<TransactionBatch, HotRodSessionManagerParameters> {
    @RegisterExtension
    static final InfinispanServerExtension INFINISPAN = new InfinispanServerExtension();

    HotRodSessionManagerITCase() {
        super(HotRodSessionManagerFactoryProvider::new);
    }

    @ParameterizedTest(name="{arguments}")
    @ArgumentsSource(value=HotRodSessionManagerArgumentsProvider.class)
    public void basic(HotRodSessionManagerParameters parameters) throws Exception {
        super.basic((SessionManagerParameters)parameters);
    }

    @ParameterizedTest(name="{arguments}")
    @ArgumentsSource(value=HotRodSessionManagerArgumentsProvider.class)
    public void concurrent(HotRodSessionManagerParameters parameters) throws Exception {
        super.concurrent((SessionManagerParameters)parameters);
    }

    @ParameterizedTest(name="{arguments}")
    @ArgumentsSource(value=HotRodSessionManagerArgumentsProvider.class)
    public void expiration(HotRodSessionManagerParameters parameters) throws Exception {
        super.expiration((SessionManagerParameters)parameters);
    }

    static class HotRodSessionManagerArgumentsProvider
    implements ArgumentsProvider {
        HotRodSessionManagerArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            Stream.Builder<Arguments> builder = Stream.builder();
            for (final SessionAttributePersistenceStrategy strategy : EnumSet.allOf(SessionAttributePersistenceStrategy.class)) {
                for (final NearCacheMode nearCacheMode : EnumSet.allOf(NearCacheMode.class)) {
                    builder.add(Arguments.of((Object[])new Object[]{new HotRodSessionManagerParameters(){

                        public SessionAttributePersistenceStrategy getSessionAttributePersistenceStrategy() {
                            return strategy;
                        }

                        @Override
                        public NearCacheMode getNearCacheMode() {
                            return nearCacheMode;
                        }

                        @Override
                        public RemoteCacheContainerConfigurator getRemoteCacheContainerConfigurator() {
                            return INFINISPAN;
                        }

                        public String toString() {
                            return Map.of(SessionAttributePersistenceStrategy.class.getSimpleName(), strategy, NearCacheMode.class.getSimpleName(), nearCacheMode).toString();
                        }
                    }}));
                }
            }
            return builder.build();
        }
    }
}

