/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote.attributes;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheComputeMutatorFactory;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionAttributes;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.CompositeImmutableSession;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.SimpleImmutableSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.fine.FineSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.fine.ImmutableSessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeMapComputeFunction;
import org.wildfly.clustering.session.infinispan.remote.attributes.SessionAttributesKey;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.common.function.Functions;

public class FineSessionAttributesFactory<S, C, L, V>
implements SessionAttributesFactory<C, Map<String, Object>> {
    private static final Logger LOGGER = Logger.getLogger(FineSessionAttributesFactory.class);
    private final RemoteCache<SessionAttributesKey, Map<String, V>> cache;
    private final Flag[] ignoreReturnFlags;
    private final Marshaller<Object, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final CacheEntryMutatorFactory<SessionAttributesKey, Map<String, V>> mutatorFactory;
    private final SessionSpecificationProvider<S, C, L> provider;

    public FineSessionAttributesFactory(SessionAttributesFactoryConfiguration<Object, V> configuration, SessionSpecificationProvider<S, C, L> provider, RemoteCacheConfiguration hotrod) {
        this.cache = hotrod.getCache();
        this.ignoreReturnFlags = hotrod.getIgnoreReturnFlags();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = hotrod.getCacheProperties();
        this.mutatorFactory = new RemoteCacheComputeMutatorFactory(this.cache, this.ignoreReturnFlags, SessionAttributeMapComputeFunction::new);
        this.provider = provider;
    }

    public Map<String, Object> createValue(String id, Void context) {
        return new ConcurrentHashMap<String, Object>();
    }

    public CompletionStage<Map<String, Object>> createValueAsync(String id, Void context) {
        return CompletableFuture.completedStage(this.createValue(id, context));
    }

    public CompletionStage<Map<String, Object>> findValueAsync(String id) {
        return this.getValueAsync(id).exceptionally(e -> {
            LOGGER.warn((Object)e.getLocalizedMessage(), e);
            this.purgeAsync(id);
            return null;
        });
    }

    public CompletionStage<Map<String, Object>> tryValueAsync(String id) {
        return this.getValueAsync(id).exceptionally(e -> null);
    }

    private CompletionStage<Map<String, Object>> getValueAsync(String id) {
        return this.cache.getAsync((Object)new SessionAttributesKey(id)).thenApply(values -> {
            Map<String, Object> attributes = this.createValue(id, null);
            if (values != null) {
                for (Map.Entry entry : values.entrySet()) {
                    String attributeName = (String)entry.getKey();
                    try {
                        attributes.put(attributeName, this.marshaller.read(entry.getValue()));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(attributeName, e);
                    }
                }
            }
            return attributes;
        });
    }

    public CompletionStage<Void> removeAsync(String id) {
        return this.cache.withFlags(this.ignoreReturnFlags).removeAsync((Object)new SessionAttributesKey(id)).thenAccept(Functions.discardingConsumer());
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, Object> attributes, ImmutableSessionMetaData metaData, C context) {
        ImmutableSessionAttributeActivationNotifier notifier = this.properties.isPersistent() ? new ImmutableSessionAttributeActivationNotifier(this.provider, (ImmutableSession)new CompositeImmutableSession(id, metaData, this.createImmutableSessionAttributes(id, attributes)), context) : null;
        return new FineSessionAttributes((Object)new SessionAttributesKey(id), attributes, this.mutatorFactory, this.marshaller, this.immutability, this.properties, (SessionAttributeActivationNotifier)notifier);
    }

    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map<String, Object> attributes) {
        return new SimpleImmutableSessionAttributes(attributes);
    }

    public void close() {
    }
}

