/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.OptionalInt;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.marshalling.MediaTypes;
import org.wildfly.clustering.cache.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.server.AutoCloseableProvider;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.MockSessionSpecificationProvider;
import org.wildfly.clustering.session.cache.SessionManagerFactoryProvider;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerParameters;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class HotRodSessionManagerFactoryProvider<C>
extends AutoCloseableProvider
implements SessionManagerFactoryProvider<C, TransactionBatch> {
    private static final String SERVER_NAME = "server";
    private static final String DEPLOYMENT_NAME_PATTERN = "%s-%s.war";
    private final HotRodSessionManagerParameters parameters;
    private final RemoteCacheContainer container;
    private final String deploymentName;

    public HotRodSessionManagerFactoryProvider(HotRodSessionManagerParameters parameters, String memberName) throws Exception {
        this.parameters = parameters;
        this.deploymentName = String.format(DEPLOYMENT_NAME_PATTERN, parameters.getSessionAttributeMarshaller(), parameters.getSessionAttributePersistenceStrategy().name());
        ClassLoader loader = HotRodSessionManagerFactory.class.getClassLoader();
        UserMarshaller marshaller = new UserMarshaller((Supplier)MediaTypes.WILDFLY_PROTOSTREAM, (ByteBufferMarshaller)new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader)).build()));
        this.container = new RemoteCacheManager(parameters.getRemoteCacheContainerConfigurator().configure(new ConfigurationBuilder().marshaller((Marshaller)marshaller)), false);
        this.container.start();
        this.accept(() -> ((RemoteCacheContainer)this.container).stop());
        Configuration configuration = this.container.getConfiguration();
        configuration.addRemoteCache(this.deploymentName, builder -> builder.forceReturnValues(false).nearCacheMode(parameters.getNearCacheMode()).transactionMode(TransactionMode.NONE).templateName(DefaultTemplate.LOCAL));
        this.accept(() -> configuration.removeRemoteCache(this.deploymentName));
    }

    public <SC> SessionManagerFactory<C, SC, TransactionBatch> createSessionManagerFactory(final Supplier<SC> contextFactory) {
        SessionManagerFactoryConfiguration managerFactoryConfiguration = new SessionManagerFactoryConfiguration<SC>(){

            public OptionalInt getMaxActiveSessions() {
                return HotRodSessionManagerFactoryProvider.this.parameters.getNearCacheMode().enabled() ? OptionalInt.of(Short.MAX_VALUE) : OptionalInt.empty();
            }

            public ByteBufferMarshaller getMarshaller() {
                return HotRodSessionManagerFactoryProvider.this.parameters.getSessionAttributeMarshaller();
            }

            public Supplier<SC> getSessionContextFactory() {
                return contextFactory;
            }

            public Immutability getImmutability() {
                return Immutability.getDefault();
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return HotRodSessionManagerFactoryProvider.this.parameters.getSessionAttributePersistenceStrategy();
            }

            public String getDeploymentName() {
                return HotRodSessionManagerFactoryProvider.this.deploymentName;
            }

            public String getServerName() {
                return HotRodSessionManagerFactoryProvider.SERVER_NAME;
            }
        };
        final RemoteCache cache = this.container.getCache(this.deploymentName);
        cache.start();
        this.accept(() -> ((RemoteCache)cache).stop());
        RemoteCacheConfiguration hotrod = new RemoteCacheConfiguration(){

            public <CK, CV> RemoteCache<CK, CV> getCache() {
                return cache;
            }
        };
        MockSessionSpecificationProvider provider = new MockSessionSpecificationProvider();
        return new HotRodSessionManagerFactory(managerFactoryConfiguration, (SessionSpecificationProvider)provider, (SessionEventListenerSpecificationProvider)provider, hotrod);
    }
}

