/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote.attributes;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheEntryComputerFactory;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.CompositeImmutableSession;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.fine.FineSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeMapComputeFunction;
import org.wildfly.clustering.session.infinispan.remote.attributes.SessionAttributesKey;

public class FineSessionAttributesFactory<C, V>
implements SessionAttributesFactory<C, Map<String, Object>> {
    private static final Logger LOGGER = Logger.getLogger(FineSessionAttributesFactory.class);
    private final RemoteCache<SessionAttributesKey, Map<String, V>> readCache;
    private final RemoteCache<SessionAttributesKey, Map<String, V>> writeCache;
    private final Marshaller<Object, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final CacheEntryMutatorFactory<SessionAttributesKey, Map<String, V>> mutatorFactory;
    private final BiFunction<ImmutableSession, C, SessionAttributeActivationNotifier> notifierFactory;

    public FineSessionAttributesFactory(SessionAttributesFactoryConfiguration<Object, V> configuration, BiFunction<ImmutableSession, C, SessionAttributeActivationNotifier> notifierFactory, RemoteCacheConfiguration hotrod) {
        this.readCache = hotrod.getCache();
        this.writeCache = hotrod.getIgnoreReturnCache();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = hotrod.getCacheProperties();
        this.mutatorFactory = new RemoteCacheEntryComputerFactory(this.readCache, SessionAttributeMapComputeFunction::new);
        this.notifierFactory = notifierFactory;
    }

    public Map<String, Object> createValue(String id, Void context) {
        return new ConcurrentHashMap<String, Object>();
    }

    public CompletionStage<Map<String, Object>> createValueAsync(String id, Void context) {
        return CompletableFuture.completedStage(this.createValue(id, context));
    }

    public CompletionStage<Map<String, Object>> findValueAsync(String id) {
        return this.getValueAsync(id).exceptionally(e -> {
            LOGGER.warn((Object)e.getLocalizedMessage(), e);
            this.purgeAsync(id);
            return null;
        });
    }

    public CompletionStage<Map<String, Object>> tryValueAsync(String id) {
        return this.getValueAsync(id).exceptionally((Function<Throwable, Map<String, Object>>)org.wildfly.clustering.function.Function.of(null));
    }

    private CompletionStage<Map<String, Object>> getValueAsync(String id) {
        return this.readCache.getAsync((Object)new SessionAttributesKey(id)).thenApply(values -> {
            Map<String, Object> attributes = this.createValue(id, null);
            if (values != null) {
                for (Map.Entry entry : values.entrySet()) {
                    String attributeName = (String)entry.getKey();
                    try {
                        attributes.put(attributeName, this.marshaller.read(entry.getValue()));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(attributeName, e);
                    }
                }
            }
            return attributes;
        });
    }

    public CompletionStage<Void> removeAsync(String id) {
        return this.writeCache.removeAsync((Object)new SessionAttributesKey(id)).thenAccept((java.util.function.Consumer)Consumer.empty());
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, Object> attributes, ImmutableSessionMetaData metaData, C context) {
        SessionAttributeActivationNotifier notifier = this.properties.isPersistent() ? this.notifierFactory.apply((ImmutableSession)new CompositeImmutableSession(id, metaData, attributes), context) : null;
        return new FineSessionAttributes((Object)new SessionAttributesKey(id), attributes, this.mutatorFactory, this.marshaller, this.immutability, this.properties, notifier);
    }

    public Map<String, Object> createImmutableSessionAttributes(String id, Map<String, Object> attributes) {
        return Map.copyOf(attributes);
    }

    public void close() {
    }
}

