/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.CacheConfiguration;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.cache.AbstractSessionManager;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerConfiguration;

public class HotRodSessionManager<C, MV, AV, SC>
extends AbstractSessionManager<C, MV, AV, SC> {
    private final Registrar<java.util.function.Consumer<ImmutableSession>> expirationListenerRegistrar;
    private final java.util.function.Consumer<ImmutableSession> expirationListener;
    private final Supplier<Batch> batchFactory;
    private AtomicReference<Registration> expirationListenerRegistration = new AtomicReference();

    public HotRodSessionManager(Supplier<SessionManager<SC>> manager, SessionManagerConfiguration<C> configuration, SessionFactory<C, MV, AV, SC> factory, HotRodSessionManagerConfiguration hotrod) {
        super(manager, configuration, (CacheConfiguration)hotrod, factory, (java.util.function.Consumer)Consumer.empty());
        this.expirationListenerRegistrar = hotrod.getExpirationListenerRegistrar();
        this.expirationListener = configuration.getExpirationListener();
        this.batchFactory = hotrod.getBatchFactory();
    }

    public boolean isStarted() {
        return this.expirationListenerRegistration.get() != null;
    }

    public void start() {
        this.expirationListenerRegistration.set(this.expirationListenerRegistrar.register(this.expirationListener));
    }

    public void stop() {
        Optional.ofNullable(this.expirationListenerRegistration.getAndSet(null)).ifPresent(Registration::close);
    }

    public Supplier<Batch> getBatchFactory() {
        return this.batchFactory;
    }

    public Set<String> getActiveSessions() {
        return Set.of();
    }

    public Set<String> getSessions() {
        return Set.of();
    }
}

