/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.spec.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.wildfly.clustering.session.ImmutableSession;

public abstract class AbstractHttpSession
implements HttpSession {
    private final ImmutableSession session;
    private final ServletContext context;

    protected AbstractHttpSession(ImmutableSession session, ServletContext context) {
        this.session = session;
        this.context = context;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getId() {
        return this.session.getId();
    }

    public long getCreationTime() {
        return this.session.getMetaData().getCreationTime().toEpochMilli();
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getMetaData().getTimeout().getSeconds();
    }

    public long getLastAccessedTime() {
        return this.session.getMetaData().getLastAccessTime().toEpochMilli();
    }

    public boolean isNew() {
        return this.session.getMetaData().isNew();
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.session.getAttributes().keySet());
    }

    public Object getAttribute(String name) {
        return this.session.getAttributes().get(name);
    }

    @Deprecated
    public String[] getValueNames() {
        return Collections.list(this.getAttributeNames()).toArray(new String[0]);
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return new HttpSessionContext(){

            public Enumeration<String> getIds() {
                return Collections.enumeration(Collections.emptyList());
            }

            public HttpSession getSession(String sessionId) {
                return null;
            }
        };
    }

    public int hashCode() {
        return this.session.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractHttpSession)) {
            return false;
        }
        AbstractHttpSession session = (AbstractHttpSession)object;
        return Objects.equals(this.session, session.session);
    }

    public String toString() {
        return this.session.toString();
    }
}

