/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session;

import java.util.Map;
import java.util.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.PassivationListener;
import org.wildfly.clustering.session.container.ContainerFacadeProvider;

public class MockContainerFacadeProvider<DC>
implements ContainerFacadeProvider<Map.Entry<ImmutableSession, DC>, DC, PassivationListener<DC>> {
    public Consumer<Map.Entry<ImmutableSession, DC>> prePassivateNotifier(PassivationListener<DC> listener) {
        return listener::passivated;
    }

    public Consumer<Map.Entry<ImmutableSession, DC>> postActivateNotifier(PassivationListener<DC> listener) {
        return listener::activated;
    }

    public PassivationListener<DC> asSessionActivationListener(final Consumer<Map.Entry<ImmutableSession, DC>> prePassivate, final Consumer<Map.Entry<ImmutableSession, DC>> postActivate) {
        return new PassivationListener<DC>(){

            @Override
            public void passivated(Map.Entry<ImmutableSession, DC> entry) {
                prePassivate.accept(entry);
            }

            @Override
            public void activated(Map.Entry<ImmutableSession, DC> entry) {
                postActivate.accept(entry);
            }
        };
    }

    public Map.Entry<ImmutableSession, DC> asSession(ImmutableSession session, DC context) {
        return Map.entry(session, context);
    }
}

