/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionAttributes;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;

public class OOBSession<C, B extends Batch>
implements Session<C>,
SessionMetaData,
SessionAttributes {
    private final SessionManager<C, B> manager;
    private final String id;
    private final C context;

    public OOBSession(SessionManager<C, B> manager, String id, C context) {
        this.manager = manager;
        this.id = id;
        this.context = context;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SessionMetaData getMetaData() {
        return this;
    }

    @Override
    public SessionAttributes getAttributes() {
        return this;
    }

    @Override
    public C getContext() {
        return this.context;
    }

    public void close() {
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean isValid() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            boolean bl = this.manager.findImmutableSession(this.id) != null;
            return bl;
        }
    }

    @Override
    public void invalidate() {
        try (Batch batch = this.manager.getBatcher().createBatch();
             Session<C> session = this.getSession();){
            session.invalidate();
        }
    }

    public boolean isExpired() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            boolean bl;
            block12: {
                Session<C> session = this.getSession();
                try {
                    bl = session.getMetaData().isExpired();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return bl;
        }
    }

    @Override
    public Instant getCreationTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Instant instant;
            block12: {
                Session<C> session = this.getSession();
                try {
                    instant = session.getMetaData().getCreationTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    @Override
    public Instant getLastAccessStartTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Instant instant;
            block12: {
                Session<C> session = this.getSession();
                try {
                    instant = session.getMetaData().getLastAccessStartTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    @Override
    public Instant getLastAccessEndTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Instant instant;
            block12: {
                Session<C> session = this.getSession();
                try {
                    instant = session.getMetaData().getLastAccessEndTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    public Duration getTimeout() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Duration duration;
            block12: {
                Session<C> session = this.getSession();
                try {
                    duration = session.getMetaData().getTimeout();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return duration;
        }
    }

    @Override
    public void setLastAccess(Instant startTime, Instant endTime) {
        throw new IllegalStateException();
    }

    @Override
    public void setTimeout(Duration duration) {
        try (Batch batch = this.manager.getBatcher().createBatch();
             Session<C> session = this.getSession();){
            session.getMetaData().setTimeout(duration);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Set<String> set;
            block12: {
                Session<C> session = this.getSession();
                try {
                    set = session.getAttributes().getAttributeNames();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return set;
        }
    }

    @Override
    public Object getAttribute(String name) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Object object;
            block12: {
                Session<C> session = this.getSession();
                try {
                    object = session.getAttributes().getAttribute(name);
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return object;
        }
    }

    @Override
    public Object removeAttribute(String name) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Object object;
            block12: {
                Session<C> session = this.getSession();
                try {
                    object = session.getAttributes().removeAttribute(name);
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return object;
        }
    }

    @Override
    public Object setAttribute(String name, Object value) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Object object;
            block12: {
                Session<C> session = this.getSession();
                try {
                    object = session.getAttributes().setAttribute(name, value);
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return object;
        }
    }

    private Session<C> getSession() {
        return Optional.ofNullable(this.manager.findSession(this.id)).orElseThrow(IllegalStateException::new);
    }
}

