/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.context.infinispan.embedded;

import java.util.OptionalInt;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jgroups.Address;
import org.springframework.beans.factory.InitializingBean;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.LocalEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKey;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.clustering.spring.context.AutoDestroyBean;
import org.wildfly.clustering.spring.context.infinispan.embedded.InfinispanConfiguration;

public class InfinispanSessionManagerFactoryBean<S, C, L>
extends AutoDestroyBean
implements SessionManagerFactory<C, Void, TransactionBatch>,
InitializingBean {
    private final SessionManagerFactoryConfiguration<Void> configuration;
    private final SessionSpecificationProvider<S, C, L> provider;
    private final InfinispanConfiguration infinispan;
    private final ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration embeddedCacheManagerConfiguration;
    private SessionManagerFactory<C, Void, TransactionBatch> sessionManagerFactory;

    public InfinispanSessionManagerFactoryBean(SessionManagerFactoryConfiguration<Void> configuration, SessionSpecificationProvider<S, C, L> provider, InfinispanConfiguration infinispan, ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration embeddedCacheManagerConfiguration) {
        this.configuration = configuration;
        this.provider = provider;
        this.infinispan = infinispan;
        this.embeddedCacheManagerConfiguration = embeddedCacheManagerConfiguration;
    }

    public void afterPropertiesSet() throws Exception {
        OptionalInt maxActiveSessions;
        Configuration template;
        final EmbeddedCacheManager container = this.embeddedCacheManagerConfiguration.getCacheContainer();
        String templateName = this.infinispan.getTemplateName();
        Configuration configuration = template = templateName != null ? container.getCacheConfiguration(templateName) : container.getDefaultCacheConfiguration();
        if (template == null) {
            throw new IllegalArgumentException(templateName);
        }
        ConfigurationBuilder builder = new ConfigurationBuilder().read(template).template(false);
        builder.encoding().mediaType("application/x-java-object");
        builder.clustering().hash().groups().enabled();
        ExpirationConfiguration expiration = builder.expiration().create();
        if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
            builder.expiration().lifespan(-1L).maxIdle(-1L);
        }
        EvictionStrategy eviction = (maxActiveSessions = this.configuration.getMaxActiveSessions()).isPresent() ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL;
        builder.memory().storage(StorageType.HEAP).whenFull(eviction).maxCount((long)maxActiveSessions.orElse(-1));
        if (eviction.isEnabled()) {
            ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(SessionMetaDataKey.class::isInstance);
        }
        String applicationName = this.configuration.getDeploymentName();
        container.defineConfiguration(applicationName, builder.build());
        this.accept(() -> container.undefineConfiguration(applicationName));
        final GroupCommandDispatcherFactory channelCommandDispatcherFactory = this.embeddedCacheManagerConfiguration.getCommandDispatcherFactory();
        EmbeddedCacheManagerCommandDispatcherFactory commandDispatcherFactory = channelCommandDispatcherFactory != null ? new EmbeddedCacheManagerCommandDispatcherFactory((EmbeddedCacheManagerCommandDispatcherFactoryConfiguration)new ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){

            public GroupCommandDispatcherFactory<Address, ChannelGroupMember> getCommandDispatcherFactory() {
                return channelCommandDispatcherFactory;
            }

            public EmbeddedCacheManager getCacheContainer() {
                return container;
            }
        }) : new EmbeddedCacheManagerCommandDispatcherFactory((EmbeddedCacheManagerCommandDispatcherFactoryConfiguration)new LocalEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){

            public EmbeddedCacheManager getCacheContainer() {
                return container;
            }
        });
        final Cache cache = container.getCache(applicationName);
        cache.start();
        this.accept(() -> ((Cache)cache).stop());
        InfinispanSessionManagerFactoryConfiguration<CacheContainerGroupMember> infinispanConfiguration = new InfinispanSessionManagerFactoryConfiguration<CacheContainerGroupMember>((CacheContainerCommandDispatcherFactory)commandDispatcherFactory){
            final /* synthetic */ CacheContainerCommandDispatcherFactory val$commandDispatcherFactory;
            {
                this.val$commandDispatcherFactory = cacheContainerCommandDispatcherFactory;
            }

            public <K, V> Cache<K, V> getCache() {
                return cache;
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return this.val$commandDispatcherFactory;
            }
        };
        this.sessionManagerFactory = new InfinispanSessionManagerFactory(this.configuration, this.provider, (InfinispanSessionManagerFactoryConfiguration)infinispanConfiguration);
        this.accept(() -> this.sessionManagerFactory.close());
    }

    public void close() {
        this.sessionManagerFactory.close();
    }

    public SessionManager<Void, TransactionBatch> createSessionManager(SessionManagerConfiguration<C> configuration) {
        return this.sessionManagerFactory.createSessionManager(configuration);
    }
}

