/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.context.infinispan.embedded;

import java.util.Properties;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.wildfly.clustering.arquillian.Tester;
import org.wildfly.clustering.cache.infinispan.remote.InfinispanServerContainer;
import org.wildfly.clustering.cache.infinispan.remote.InfinispanServerExtension;
import org.wildfly.clustering.session.container.AbstractSessionManagerITCase;
import org.wildfly.clustering.session.container.SessionManagementTesterConfiguration;

public class AbstractInfinispanInvalidationSessionManagerITCase
extends AbstractSessionManagerITCase
implements UnaryOperator<Properties> {
    @RegisterExtension
    static final InfinispanServerExtension INFINISPAN = new InfinispanServerExtension();
    private static final String CACHE_NAME = "test";

    protected AbstractInfinispanInvalidationSessionManagerITCase(SessionManagementTesterConfiguration configuration) {
        super(configuration);
    }

    protected AbstractInfinispanInvalidationSessionManagerITCase(Function<SessionManagementTesterConfiguration, Tester> testerFactory, SessionManagementTesterConfiguration configuration) {
        super(testerFactory, configuration);
    }

    @BeforeAll
    public static void init() {
        Configuration configuration = INFINISPAN.configure(new ConfigurationBuilder());
        try (RemoteCacheManager manager = new RemoteCacheManager(configuration);){
            configuration.addRemoteCache(CACHE_NAME, builder -> builder.forceReturnValues(false).transactionMode(TransactionMode.NONE).templateName(DefaultTemplate.LOCAL));
            RemoteCache cache = manager.getCache(CACHE_NAME);
            cache.start();
            cache.stop();
        }
    }

    public WebArchive createArchive(SessionManagementTesterConfiguration configuration) {
        return (WebArchive)super.createArchive(configuration).addAsWebInfResource("infinispan-invalidation.xml", "infinispan.xml");
    }

    @Override
    public Properties apply(Properties properties) {
        InfinispanServerContainer container = (InfinispanServerContainer)INFINISPAN.getContainer();
        properties.setProperty("infinispan.server.host", container.getHost());
        properties.setProperty("infinispan.server.port", Integer.toString(container.getPort()));
        properties.setProperty("infinispan.server.username", container.getUsername());
        properties.setProperty("infinispan.server.password", String.valueOf(container.getPassword()));
        properties.setProperty("infinispan.server.intelligence", (container.isPortMapping() ? ClientIntelligence.BASIC : ClientIntelligence.HASH_DISTRIBUTION_AWARE).name());
        properties.setProperty("infinispan.server.template", DefaultTemplate.LOCAL.getTemplateName());
        properties.setProperty("infinispan.server.cache", CACHE_NAME);
        return properties;
    }
}

