/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.context.infinispan.remote;

import io.reactivex.rxjava3.schedulers.Schedulers;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.wildfly.clustering.cache.infinispan.marshalling.MediaTypes;
import org.wildfly.clustering.cache.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.spring.context.AutoDestroyBean;
import org.wildfly.clustering.spring.context.infinispan.remote.HotRodConfiguration;
import org.wildfly.clustering.spring.context.infinispan.remote.RemoteCacheContainerProvider;

public class RemoteCacheContainerProviderBean
extends AutoDestroyBean
implements RemoteCacheContainerProvider,
InitializingBean,
ResourceLoaderAware {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final HotRodConfiguration configuration;
    private RemoteCacheContainer container;
    private ClassLoader loader;

    public RemoteCacheContainerProviderBean(HotRodConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public RemoteCacheContainer getRemoteCacheContainer() {
        return this.container;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader.getClassLoader();
    }

    public void afterPropertiesSet() throws Exception {
        COUNTER.incrementAndGet();
        this.accept(() -> {
            if (COUNTER.decrementAndGet() == 0) {
                Schedulers.shutdown();
            }
        });
        URI uri = this.configuration.getUri();
        Configuration configuration = (uri != null ? HotRodURI.create((URI)uri).toConfigurationBuilder() : new ConfigurationBuilder()).withProperties(this.configuration.getProperties()).marshaller((Marshaller)new UserMarshaller((Supplier)MediaTypes.WILDFLY_PROTOSTREAM, (ByteBufferMarshaller)new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)this.loader)).load(this.loader)).build()))).asyncExecutorFactory().factory(new ExecutorFactory(){

            public ThreadPoolExecutor getExecutor(Properties p) {
                ConfigurationProperties properties = new ConfigurationProperties(p);
                final String threadNamePrefix = properties.getDefaultExecutorFactoryThreadNamePrefix();
                final String threadNameSuffix = properties.getDefaultExecutorFactoryThreadNameSuffix();
                final NonBlockingThreadGroup group = new NonBlockingThreadGroup(threadNamePrefix + "-group");
                ThreadFactory factory = new ThreadFactory(){
                    private final AtomicInteger counter = new AtomicInteger(0);
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public Thread newThread(Runnable task) {
                        int threadIndex = this.counter.incrementAndGet();
                        Thread thread = new Thread(group, task, threadNamePrefix + "-" + threadIndex + threadNameSuffix);
                        thread.setDaemon(true);
                        return thread;
                    }
                };
                return new ThreadPoolExecutor(properties.getDefaultExecutorFactoryPoolSize(), properties.getDefaultExecutorFactoryPoolSize(), 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory(factory, RemoteCacheContainerProviderBean.this.loader));
            }
        }).build();
        this.container = new RemoteCacheManager(configuration, false);
        this.container.start();
        this.accept(() -> ((RemoteCacheContainer)this.container).stop());
    }

    static class NonBlockingThreadGroup
    extends ThreadGroup
    implements NonBlockingResource {
        NonBlockingThreadGroup(String name) {
            super(name);
        }
    }
}

