/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security;

import java.io.IOException;
import java.util.Collections;
import java.util.function.UnaryOperator;
import javax.security.auth.login.LoginContext;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.jaas.JaasAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;

public class SpringSecurityAuthenticationMarshallerTestCase {
    @Test
    public void test() throws IOException {
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        UnaryOperator withDetails = token -> {
            token.setDetails((Object)"details");
            return token;
        };
        tester.test((Object)((AbstractAuthenticationToken)withDetails.apply(new AnonymousAuthenticationToken("foo", (Object)"bar", Collections.singletonList(new SimpleGrantedAuthority("admin"))))));
        tester.test((Object)((AbstractAuthenticationToken)withDetails.apply(new RememberMeAuthenticationToken("foo", (Object)"bar", Collections.emptySet()))));
        tester.test((Object)((AbstractAuthenticationToken)withDetails.apply(new RememberMeAuthenticationToken("foo", (Object)"bar", Collections.singletonList(new SimpleGrantedAuthority("admin"))))));
        tester.test((Object)((AbstractAuthenticationToken)withDetails.apply(new UsernamePasswordAuthenticationToken((Object)"username", (Object)"password"))));
        tester.test((Object)((AbstractAuthenticationToken)withDetails.apply(new UsernamePasswordAuthenticationToken((Object)"foo", (Object)"bar", Collections.singletonList(new SimpleGrantedAuthority("admin"))))));
        LoginContext context = (LoginContext)Mockito.mock(LoginContext.class);
        tester.test((Object)((AbstractAuthenticationToken)withDetails.apply(new JaasAuthenticationToken((Object)"username", (Object)"password", context))));
        tester.test((Object)((AbstractAuthenticationToken)withDetails.apply(new JaasAuthenticationToken((Object)"foo", (Object)"bar", Collections.singletonList(new SimpleGrantedAuthority("admin")), context))));
    }
}

