/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security;

import jakarta.servlet.http.Cookie;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.SavedCookie;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.spring.security.Scheme;

public class SpringSecurityWebSavedRequestMarshallerTestCase {
    @Test
    public void test() throws IOException {
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        TreeMap<String, String[]> parameters = new TreeMap<String, String[]>();
        parameters.put("foo", new String[]{"true"});
        parameters.put("bar", new String[]{"1", "2"});
        DefaultSavedRequest.Builder builder = new DefaultSavedRequest.Builder();
        builder.setMethod(HttpMethod.GET.name());
        builder.setScheme(Scheme.HTTPS.getName());
        builder.setServerName(InetAddress.getLoopbackAddress().getHostName());
        builder.setServerPort(Scheme.HTTPS.getDefaultPort());
        builder.setServletPath("");
        builder.setContextPath("");
        builder.setQueryString("foo=true&bar=1&bar=2");
        builder.setParameters(parameters);
        builder.setRequestURI("");
        builder.setRequestURL(String.format("https://%s", InetAddress.getLoopbackAddress().getHostName()));
        tester.test((Object)builder.build(), SpringSecurityWebSavedRequestMarshallerTestCase::assertEquals);
        builder = new DefaultSavedRequest.Builder();
        builder.setMethod(HttpMethod.POST.name());
        builder.setScheme(Scheme.HTTP.getName());
        builder.setServerName(InetAddress.getLocalHost().getHostName());
        builder.setServerPort(8080);
        builder.setContextPath("/foo");
        builder.setServletPath("/bar");
        builder.setPathInfo("/extra/path");
        builder.setParameters(parameters);
        builder.setHeaders(Collections.singletonMap("Accept", Collections.singletonList("text/html")));
        builder.setLocales(Collections.singletonList(Locale.US));
        Cookie cookie = new Cookie("name", "value");
        cookie.setDomain("domain");
        cookie.setMaxAge(100);
        cookie.setPath("/path");
        cookie.setSecure(true);
        builder.setCookies(Arrays.asList(new SavedCookie(new Cookie("foo", "bar")), new SavedCookie(cookie)));
        builder.setRequestURI("/foo/bar/extra/path");
        builder.setRequestURL(String.format("http://%s:8080/foo/bar/extra/path", InetAddress.getLocalHost().getHostName()));
        tester.test((Object)builder.build(), SpringSecurityWebSavedRequestMarshallerTestCase::assertEquals);
    }

    private static void assertEquals(DefaultSavedRequest request1, DefaultSavedRequest request2) {
        Assertions.assertEquals((Object)request1.getMethod(), (Object)request2.getMethod());
        Assertions.assertEquals((Object)request1.getScheme(), (Object)request2.getScheme());
        Assertions.assertEquals((Object)request1.getServerName(), (Object)request2.getServerName());
        Assertions.assertEquals((int)request1.getServerPort(), (int)request2.getServerPort());
        Assertions.assertEquals((Object)request1.getServletPath(), (Object)request2.getServletPath());
        Assertions.assertEquals((Object)request1.getContextPath(), (Object)request2.getContextPath());
        Assertions.assertEquals((Object)request1.getPathInfo(), (Object)request2.getPathInfo());
        Assertions.assertEquals((Object)request1.getQueryString(), (Object)request2.getQueryString());
        Assertions.assertEquals((Object)request1.getRequestURI(), (Object)request2.getRequestURI());
        Assertions.assertEquals((Object)request1.getRequestURL(), (Object)request2.getRequestURL());
        Assertions.assertEquals((Object)request1.getRedirectUrl(), (Object)request2.getRedirectUrl());
        Assertions.assertEquals((Object)request1.getParameterNames(), (Object)request2.getParameterNames());
        for (String parameterName : request1.getParameterNames()) {
            Assertions.assertArrayEquals((Object[])request1.getParameterValues(parameterName), (Object[])request2.getParameterValues(parameterName));
        }
        Assertions.assertEquals((Object)request1.getHeaderNames(), (Object)request2.getHeaderNames());
        for (String headerName : request1.getHeaderNames()) {
            Assertions.assertEquals((Object)request1.getHeaderValues(headerName), (Object)request2.getHeaderValues(headerName));
        }
        Assertions.assertEquals((Object)request1.getLocales(), (Object)request2.getLocales());
        List cookies1 = request1.getCookies();
        List cookies2 = request2.getCookies();
        Assertions.assertEquals((int)cookies1.size(), (int)cookies2.size());
        for (int i = 0; i < cookies1.size(); ++i) {
            Cookie cookie1 = (Cookie)cookies1.get(i);
            Cookie cookie2 = (Cookie)cookies2.get(i);
            Assertions.assertEquals((Object)cookie1.getName(), (Object)cookie2.getName());
            Assertions.assertEquals((Object)cookie1.getValue(), (Object)cookie2.getValue());
            Assertions.assertEquals((Object)cookie1.getDomain(), (Object)cookie2.getDomain());
            Assertions.assertEquals((int)cookie1.getMaxAge(), (int)cookie2.getMaxAge());
            Assertions.assertEquals((Object)cookie1.getPath(), (Object)cookie2.getPath());
            Assertions.assertEquals((Object)cookie1.getSecure(), (Object)cookie2.getSecure());
        }
    }
}

