/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.web.authentication.preauth;

import java.io.IOException;
import java.util.LinkedList;
import org.infinispan.protostream.descriptors.WireType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;
import org.wildfly.clustering.marshalling.protostream.FieldReadable;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Writable;
import org.wildfly.clustering.spring.security.web.authentication.HttpServletRequestBuilder;
import org.wildfly.clustering.spring.security.web.authentication.HttpServletRequestMarshaller;
import org.wildfly.clustering.spring.security.web.authentication.MockHttpServletRequest;

public class PreAuthenticatedWebAuthenticationDetailsMarshaller
implements ProtoStreamMarshaller<PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails> {
    private static final int HTTP_SERVLET_REQUEST_INDEX = 1;
    private static final int AUTHORITIY_INDEX = 1 + HttpServletRequestMarshaller.INSTANCE.getFields();

    public PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader requestReader = reader.createFieldSetReader((FieldReadable)HttpServletRequestMarshaller.INSTANCE, 1);
        HttpServletRequestBuilder builder = HttpServletRequestMarshaller.INSTANCE.createInitialValue();
        LinkedList<GrantedAuthority> authorities = new LinkedList<GrantedAuthority>();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (requestReader.contains(index)) {
                builder = (HttpServletRequestBuilder)requestReader.readField((Object)builder);
                continue;
            }
            if (index == AUTHORITIY_INDEX) {
                authorities.add((GrantedAuthority)reader.readAny(GrantedAuthority.class));
                continue;
            }
            reader.skipField(tag);
        }
        return new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(builder.get(), authorities);
    }

    public void writeTo(ProtoStreamWriter writer, PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails details) throws IOException {
        writer.createFieldSetWriter((Writable)HttpServletRequestMarshaller.INSTANCE, 1).writeFields((Object)new MockHttpServletRequest((WebAuthenticationDetails)details));
        for (GrantedAuthority authority : details.getGrantedAuthorities()) {
            writer.writeAny(AUTHORITIY_INDEX, (Object)authority);
        }
    }

    public Class<? extends PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails> getJavaClass() {
        return PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails.class;
    }
}

