/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.web.savedrequest;

import jakarta.servlet.http.Cookie;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.infinispan.protostream.descriptors.WireType;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.SavedCookie;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.spring.security.Scheme;

public class SavedRequestMarshaller
implements ProtoStreamMarshaller<DefaultSavedRequest> {
    private static final int METHOD_INDEX = 1;
    private static final int SCHEME_INDEX = 2;
    private static final int SERVER_NAME_INDEX = 3;
    private static final int SERVER_PORT_INDEX = 4;
    private static final int CONTEXT_PATH_INDEX = 5;
    private static final int SERVLET_PATH_INDEX = 6;
    private static final int QUERY_INDEX = 7;
    private static final int PARAMETER_NAME_INDEX = 8;
    private static final int PARAMETER_VALUE_INDEX = 9;
    private static final int PARAMETER_VALUES_INDEX = 10;
    private static final int HEADER_NAME_INDEX = 11;
    private static final int HEADER_VALUE_INDEX = 12;
    private static final int HEADER_VALUES_INDEX = 13;
    private static final int LOCALE_INDEX = 14;
    private static final int COOKIE_INDEX = 15;
    private static final int PATH_INFO_INDEX = 16;
    private static final String DEFAULT_METHOD = HttpMethod.GET.name();
    private static final Scheme DEFAULT_SCHEME = Scheme.HTTPS;
    private static final String DEFAULT_SERVER_NAME = InetAddress.getLoopbackAddress().getHostName();
    private static final int DEFAULT_SERVER_PORT = Scheme.HTTP.getDefaultPort();
    private static final String DEFAULT_CONTEXT_PATH = "";
    private static final String DEFAULT_SERVLET_PATH = "";

    public DefaultSavedRequest readFrom(ProtoStreamReader reader) throws IOException {
        Iterator values;
        Iterator names;
        DefaultSavedRequest.Builder builder = new DefaultSavedRequest.Builder();
        builder.setMethod(DEFAULT_METHOD);
        builder.setScheme(DEFAULT_SCHEME.getName());
        builder.setServerName(DEFAULT_SERVER_NAME);
        builder.setServerPort(DEFAULT_SERVER_PORT);
        builder.setContextPath("");
        builder.setServletPath("");
        LinkedList<String> parameterNames = new LinkedList<String>();
        LinkedList<String[]> parameterValues = new LinkedList<String[]>();
        LinkedList<String> headerNames = new LinkedList<String>();
        LinkedList<String[]> headerValues = new LinkedList<String[]>();
        LinkedList<Locale> locales = new LinkedList<Locale>();
        LinkedList<SavedCookie> cookies = new LinkedList<SavedCookie>();
        block18: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    builder.setMethod(reader.readString());
                    continue block18;
                }
                case 2: {
                    builder.setScheme(((Scheme)reader.readEnum(Scheme.class)).getName());
                    continue block18;
                }
                case 3: {
                    builder.setServerName(reader.readString());
                    continue block18;
                }
                case 4: {
                    builder.setServerPort(reader.readUInt32());
                    continue block18;
                }
                case 5: {
                    builder.setContextPath(reader.readString());
                    continue block18;
                }
                case 6: {
                    builder.setServletPath(reader.readString());
                    continue block18;
                }
                case 16: {
                    builder.setPathInfo(reader.readString());
                    continue block18;
                }
                case 7: {
                    builder.setQueryString(reader.readString());
                    continue block18;
                }
                case 8: {
                    parameterNames.add(reader.readString());
                    continue block18;
                }
                case 9: {
                    parameterValues.add(new String[]{reader.readString()});
                    continue block18;
                }
                case 10: {
                    parameterValues.add((String[])reader.readAny(String[].class));
                    continue block18;
                }
                case 11: {
                    headerNames.add(reader.readString());
                    continue block18;
                }
                case 12: {
                    headerValues.add(new String[]{reader.readString()});
                    continue block18;
                }
                case 13: {
                    headerValues.add((String[])reader.readAny(String[].class));
                    continue block18;
                }
                case 14: {
                    locales.add((Locale)reader.readObject(Locale.class));
                    continue block18;
                }
                case 15: {
                    cookies.add((SavedCookie)reader.readObject(SavedCookie.class));
                    continue block18;
                }
            }
            reader.skipField(tag);
        }
        if (!parameterNames.isEmpty()) {
            TreeMap<String, String[]> parameters = new TreeMap<String, String[]>();
            names = parameterNames.iterator();
            values = parameterValues.iterator();
            while (names.hasNext() && values.hasNext()) {
                parameters.put((String)names.next(), (String[])values.next());
            }
            builder.setParameters(parameters);
        }
        if (!headerNames.isEmpty()) {
            TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
            names = headerNames.iterator();
            values = headerValues.iterator();
            while (names.hasNext() && values.hasNext()) {
                headers.put((String)names.next(), Arrays.asList((String[])values.next()));
            }
            builder.setHeaders(headers);
        }
        builder.setLocales(locales);
        builder.setCookies(cookies);
        DefaultSavedRequest request = builder.build();
        String query = request.getQueryString();
        if (query != null) {
            TreeMap<String, LinkedList<String>> map = new TreeMap<String, LinkedList<String>>();
            for (String parameter : query.split(Pattern.quote("&"))) {
                String[] values2 = parameter.split(Pattern.quote("="));
                String name = values2[0];
                String value = values2[1];
                LinkedList<String> list = (LinkedList<String>)map.get(name);
                if (list == null) {
                    list = new LinkedList<String>();
                    map.put(name, list);
                }
                list.add(value);
            }
            for (Map.Entry entry : map.entrySet()) {
                request.getParameterMap().put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
            }
            builder.setParameters(request.getParameterMap());
        }
        StringBuilder uriBuilder = new StringBuilder();
        if (request.getContextPath() != null) {
            uriBuilder.append(request.getContextPath());
        }
        if (request.getServletPath() != null) {
            uriBuilder.append(request.getServletPath());
        }
        if (request.getPathInfo() != null) {
            uriBuilder.append(request.getPathInfo());
        }
        String requestURI = uriBuilder.toString();
        builder.setRequestURI(requestURI);
        StringBuilder stringBuilder = new StringBuilder(request.getScheme()).append("://").append(request.getServerName());
        if (Scheme.resolve(request.getScheme()).getDefaultPort() != request.getServerPort()) {
            stringBuilder.append(':').append(request.getServerPort());
        }
        builder.setRequestURL(stringBuilder.append(requestURI).toString());
        return builder.build();
    }

    public void writeTo(ProtoStreamWriter writer, DefaultSavedRequest request) throws IOException {
        String pathInfo;
        String servletPath;
        String contextPath;
        int serverPort;
        String serverName;
        Scheme scheme;
        String method = request.getMethod();
        if (!method.equals(DEFAULT_METHOD)) {
            writer.writeString(1, method);
        }
        if ((scheme = Scheme.resolve(request.getScheme())) != DEFAULT_SCHEME) {
            writer.writeEnum(2, (Enum)scheme);
        }
        if (!(serverName = request.getServerName()).equals(DEFAULT_SERVER_NAME)) {
            writer.writeString(3, serverName);
        }
        if ((serverPort = request.getServerPort()) != DEFAULT_SERVER_PORT) {
            writer.writeUInt32(4, serverPort);
        }
        if (!(contextPath = request.getContextPath()).equals("")) {
            writer.writeString(5, contextPath);
        }
        if (!(servletPath = request.getServletPath()).equals("")) {
            writer.writeString(6, servletPath);
        }
        if ((pathInfo = request.getPathInfo()) != null) {
            writer.writeString(16, pathInfo);
        }
        if (method.equals(HttpMethod.GET.name())) {
            String query = request.getQueryString();
            if (query != null) {
                writer.writeString(7, query);
            }
        } else if (method.equals(HttpMethod.POST.name())) {
            for (String parameterName : request.getParameterNames()) {
                writer.writeString(8, parameterName);
                String[] parameterValues = request.getParameterValues(parameterName);
                if (parameterValues.length == 1) {
                    writer.writeString(9, parameterValues[0]);
                    continue;
                }
                writer.writeAny(10, (Object)parameterValues);
            }
        }
        for (String headerName : request.getHeaderNames()) {
            writer.writeString(11, headerName);
            List headerValues = request.getHeaderValues(headerName);
            if (headerValues.size() == 1) {
                writer.writeString(12, (String)headerValues.get(0));
                continue;
            }
            writer.writeAny(13, (Object)headerValues.toArray(new String[0]));
        }
        for (Locale locale : request.getLocales()) {
            writer.writeObject(14, (Object)locale);
        }
        for (Cookie cookie : request.getCookies()) {
            writer.writeObject(15, (Object)new SavedCookie(cookie));
        }
    }

    public Class<? extends DefaultSavedRequest> getJavaClass() {
        return DefaultSavedRequest.class;
    }
}

