/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security;

import java.util.Collections;
import java.util.function.UnaryOperator;
import javax.security.auth.login.LoginContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.mockito.Mockito;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.jaas.JaasAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;

public class SpringSecurityAuthenticationMarshallerTestCase {
    @ParameterizedTest
    @TesterFactorySource
    public void test(TesterFactory factory) {
        Tester tester = factory.createTester();
        UnaryOperator withDetails = token -> {
            token.setDetails((Object)"details");
            return token;
        };
        tester.accept((Object)((AbstractAuthenticationToken)withDetails.apply(new AnonymousAuthenticationToken("foo", (Object)"bar", Collections.singletonList(new SimpleGrantedAuthority("admin"))))));
        tester.accept((Object)((AbstractAuthenticationToken)withDetails.apply(new RememberMeAuthenticationToken("foo", (Object)"bar", Collections.emptySet()))));
        tester.accept((Object)((AbstractAuthenticationToken)withDetails.apply(new RememberMeAuthenticationToken("foo", (Object)"bar", Collections.singletonList(new SimpleGrantedAuthority("admin"))))));
        tester.accept((Object)((AbstractAuthenticationToken)withDetails.apply(new UsernamePasswordAuthenticationToken((Object)"username", (Object)"password"))));
        tester.accept((Object)((AbstractAuthenticationToken)withDetails.apply(new UsernamePasswordAuthenticationToken((Object)"foo", (Object)"bar", Collections.singletonList(new SimpleGrantedAuthority("admin"))))));
        LoginContext context = (LoginContext)Mockito.mock(LoginContext.class);
        tester.accept((Object)((AbstractAuthenticationToken)withDetails.apply(new JaasAuthenticationToken((Object)"username", (Object)"password", context))));
        tester.accept((Object)((AbstractAuthenticationToken)withDetails.apply(new JaasAuthenticationToken((Object)"foo", (Object)"bar", Collections.singletonList(new SimpleGrantedAuthority("admin")), context))));
    }
}

