/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.authentication;

import java.util.Collection;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.wildfly.clustering.marshalling.protostream.AbstractSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.spring.security.authentication.CredentialAuthenticationMarshaller;
import org.wildfly.clustering.spring.security.authentication.HashAuthenticationTokenMarshaller;

public class SpringSecurityAuthenticationSerializationContextInitializer
extends AbstractSerializationContextInitializer {
    public SpringSecurityAuthenticationSerializationContextInitializer() {
        super("org.springframework.security.authentication.proto");
    }

    public void registerMarshallers(SerializationContext context) {
        context.registerMarshaller(new HashAuthenticationTokenMarshaller<AnonymousAuthenticationToken>(AnonymousAuthenticationToken.class, AnonymousAuthenticationToken::getKeyHash));
        context.registerMarshaller(new HashAuthenticationTokenMarshaller<RememberMeAuthenticationToken>(RememberMeAuthenticationToken.class, RememberMeAuthenticationToken::getKeyHash));
        context.registerMarshaller(new CredentialAuthenticationMarshaller<UsernamePasswordAuthenticationToken>(UsernamePasswordAuthenticationToken::new, (entry, authorities) -> new UsernamePasswordAuthenticationToken(entry.getKey(), entry.getValue(), (Collection)authorities)).asMarshaller(UsernamePasswordAuthenticationToken.class));
    }
}

