/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.core.userdetails;

import java.io.IOException;
import java.util.BitSet;
import java.util.LinkedList;
import org.infinispan.protostream.descriptors.WireType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class UserDetailsMarshaller
implements ProtoStreamMarshaller<User> {
    private static final int USERNAME_INDEX = 1;
    private static final int PASSWORD_INDEX = 2;
    private static final int AUTHORITY_INDEX = 3;
    private static final int FLAGS_INDEX = 4;
    private static final int DISABLED = 0;
    private static final int ACCOUNT_EXPIRED = 1;
    private static final int CREDENTIALS_EXPIRED = 2;
    private static final int ACCOUNT_LOCKED = 3;
    private static final int FLAGS = 4;

    public User readFrom(ProtoStreamReader reader) throws IOException {
        User.UserBuilder builder = User.builder().password("");
        LinkedList<GrantedAuthority> authorities = new LinkedList<GrantedAuthority>();
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    builder.username(reader.readString());
                    continue block6;
                }
                case 2: {
                    builder.password(reader.readString());
                    continue block6;
                }
                case 3: {
                    authorities.add((GrantedAuthority)reader.readAny(GrantedAuthority.class));
                    continue block6;
                }
                case 4: {
                    BitSet flags = (BitSet)reader.readObject(BitSet.class);
                    builder.disabled(flags.get(0));
                    builder.accountExpired(flags.get(1));
                    builder.credentialsExpired(flags.get(2));
                    builder.accountLocked(flags.get(3));
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        if (!authorities.isEmpty()) {
            builder.authorities(authorities);
        }
        return (User)builder.build();
    }

    public void writeTo(ProtoStreamWriter writer, User user) throws IOException {
        writer.writeString(1, user.getUsername());
        String password = user.getPassword();
        if (password != null && !password.isEmpty()) {
            writer.writeString(2, password);
        }
        for (GrantedAuthority authority : user.getAuthorities()) {
            writer.writeAny(3, (Object)authority);
        }
        BitSet flags = new BitSet(4);
        if (!user.isEnabled()) {
            flags.set(0);
        }
        if (!user.isAccountNonExpired()) {
            flags.set(1);
        }
        if (!user.isCredentialsNonExpired()) {
            flags.set(2);
        }
        if (!user.isAccountNonLocked()) {
            flags.set(3);
        }
        if (!flags.isEmpty()) {
            writer.writeObject(4, (Object)flags);
        }
    }

    public Class<? extends User> getJavaClass() {
        return User.class;
    }
}

