/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.spring.security.web.authentication.HttpServletRequestBuilder;

public enum HttpServletRequestMarshaller implements FieldSetMarshaller.Supplied<HttpServletRequest, HttpServletRequestBuilder>
{
    INSTANCE;

    private static final int REMOTE_ADDRESS_INDEX = 0;
    private static final int SESSION_ID_INDEX = 1;
    private static final int FIELDS = 2;

    public HttpServletRequestBuilder createInitialValue() {
        return new HttpServletRequestBuilder();
    }

    public HttpServletRequestBuilder readFrom(ProtoStreamReader reader, int index, WireType type, HttpServletRequestBuilder builder) throws IOException {
        switch (index) {
            case 0: {
                return builder.setRemoteAddress(reader.readString());
            }
            case 1: {
                return builder.setSessionId(reader.readString());
            }
        }
        reader.skipField(type);
        return builder;
    }

    public void writeTo(ProtoStreamWriter writer, HttpServletRequest request) throws IOException {
        HttpSession session;
        String remoteAddress = request.getRemoteAddr();
        if (remoteAddress != null) {
            writer.writeString(0, remoteAddress);
        }
        if ((session = request.getSession(false)) != null) {
            writer.writeString(1, session.getId());
        }
    }

    public int getFields() {
        return 2;
    }
}

