/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security;

public enum Scheme {
    HTTP("http", 80),
    HTTPS("https", 443);

    private final String name;
    private final int defaultPort;

    private Scheme(String name, int defaultPort) {
        this.name = name;
        this.defaultPort = defaultPort;
    }

    public String getName() {
        return this.name;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public static Scheme resolve(String name) {
        switch (name) {
            case "http": {
                return HTTP;
            }
            case "https": {
                return HTTPS;
            }
        }
        throw new IllegalArgumentException(name);
    }
}

