/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.web.savedrequest;

import jakarta.servlet.http.Cookie;
import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.springframework.security.web.savedrequest.SavedCookie;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class SavedCookieMarshaller
implements ProtoStreamMarshaller<SavedCookie> {
    private static final int NAME_INDEX = 1;
    private static final int SECURE_NAME_INDEX = 2;
    private static final int VALUE_INDEX = 3;
    private static final int HTTP_ONLY_VALUE_INDEX = 4;
    private static final int DOMAIN_INDEX = 5;
    private static final int MAX_AGE_INDEX = 6;
    private static final int PATH_INDEX = 7;
    private static final int DEFAULT_MAX_AGE = -1;

    public SavedCookie readFrom(ProtoStreamReader reader) throws IOException {
        String name = null;
        String value = null;
        boolean secure = false;
        boolean httpOnly = false;
        String domain = null;
        int maxAge = -1;
        String path = null;
        block9: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 2: {
                    secure = true;
                }
                case 1: {
                    name = reader.readString();
                    continue block9;
                }
                case 4: {
                    httpOnly = true;
                }
                case 3: {
                    value = reader.readString();
                    continue block9;
                }
                case 5: {
                    domain = reader.readString();
                    continue block9;
                }
                case 6: {
                    maxAge = reader.readUInt32();
                    continue block9;
                }
                case 7: {
                    path = reader.readString();
                    continue block9;
                }
            }
            reader.skipField(tag);
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setDomain(domain);
        cookie.setHttpOnly(httpOnly);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        cookie.setSecure(secure);
        return new SavedCookie(cookie);
    }

    public void writeTo(ProtoStreamWriter writer, SavedCookie cookie) throws IOException {
        String path;
        int maxAge;
        String domain;
        String name = cookie.getName();
        writer.writeString(cookie.isSecure() ? 2 : 1, name);
        String value = cookie.getValue();
        if (value != null) {
            writer.writeString(3, value);
        }
        if ((domain = cookie.getDomain()) != null) {
            writer.writeString(5, domain);
        }
        if ((maxAge = cookie.getMaxAge()) != -1) {
            writer.writeUInt32(6, maxAge);
        }
        if ((path = cookie.getPath()) != null) {
            writer.writeString(7, path);
        }
    }

    public Class<? extends SavedCookie> getJavaClass() {
        return SavedCookie.class;
    }
}

