/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.authentication;

import java.io.IOException;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.spring.security.authentication.AuthenticationTokenConfiguration;

public class AuthenticationMarshaller<A extends Authentication>
implements FieldSetMarshaller<A, AuthenticationTokenConfiguration> {
    private static final int PRINCIPAL_INDEX = 0;
    private static final int CREDENTIALS_INDEX = 1;
    private static final int GRANTED_AUTHORITY_INDEX = 2;
    private static final int DETAILS_INDEX = 3;
    private static final int FIELDS = 4;
    private final Function<AuthenticationTokenConfiguration, A> factory;

    AuthenticationMarshaller(Function<AuthenticationTokenConfiguration, A> factory) {
        this.factory = factory;
    }

    public AuthenticationTokenConfiguration createInitialValue() {
        return new AuthenticationTokenConfiguration();
    }

    public A build(AuthenticationTokenConfiguration config) {
        return (A)((Authentication)this.factory.apply(config));
    }

    public AuthenticationTokenConfiguration readFrom(ProtoStreamReader reader, int index, WireType type, AuthenticationTokenConfiguration config) throws IOException {
        switch (index) {
            case 0: {
                return config.setPrincipal(reader.readAny());
            }
            case 1: {
                return config.setCredentials(reader.readAny());
            }
            case 2: {
                return config.addAuthority((GrantedAuthority)reader.readAny(GrantedAuthority.class));
            }
            case 3: {
                return config.setDetails(reader.readAny());
            }
        }
        reader.skipField(type);
        return config;
    }

    public void writeTo(ProtoStreamWriter writer, A token) throws IOException {
        Object principal = token.getPrincipal();
        if (principal != null) {
            writer.writeAny(0, token.getPrincipal());
        }
        Object credentials = token.getCredentials();
        if (!this.createInitialValue().getCredentials().equals(credentials)) {
            writer.writeAny(1, credentials);
        }
        for (GrantedAuthority authority : token.getAuthorities()) {
            writer.writeAny(2, (Object)authority);
        }
        Object details = token.getDetails();
        if (details != null) {
            writer.writeAny(3, details);
        }
    }

    public int getFields() {
        return 4;
    }
}

