/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.authentication;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.wildfly.clustering.spring.security.authentication.AuthenticationMarshaller;
import org.wildfly.clustering.spring.security.authentication.AuthenticationTokenConfiguration;

public class CredentialAuthenticationMarshaller<T extends AbstractAuthenticationToken>
extends AuthenticationMarshaller<T> {
    public CredentialAuthenticationMarshaller(final BiFunction<Object, Object, T> unauthenticatedFactory, final BiFunction<Map.Entry<Object, Object>, List<GrantedAuthority>, T> authenticatedFactory) {
        super(new Function<AuthenticationTokenConfiguration, T>(){

            @Override
            public T apply(AuthenticationTokenConfiguration config) {
                Object principal = config.getPrincipal();
                Object credentials = config.getCredentials();
                List<GrantedAuthority> authorities = config.getAuthorities();
                AbstractAuthenticationToken token = authorities.isEmpty() ? (AbstractAuthenticationToken)unauthenticatedFactory.apply(principal, credentials) : (AbstractAuthenticationToken)authenticatedFactory.apply(new AbstractMap.SimpleImmutableEntry<Object, Object>(principal, credentials), authorities);
                token.setDetails(config.getDetails());
                return token;
            }
        });
    }
}

