/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.authentication;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.infinispan.protostream.descriptors.WireType;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.spring.security.authentication.AuthenticationMarshaller;
import org.wildfly.clustering.spring.security.authentication.AuthenticationTokenConfiguration;

public class HashAuthenticationTokenMarshaller<T extends AbstractAuthenticationToken>
implements ProtoStreamMarshaller<T> {
    private static final int HASH_INDEX = 1;
    private static final int TOKEN_INDEX = 2;
    private static final int DEFAULT_HASH = 0;
    private final Class<T> tokenClass;
    private final ToIntFunction<T> hash;

    public HashAuthenticationTokenMarshaller(Class<T> tokenClass, ToIntFunction<T> hash) {
        this.tokenClass = tokenClass;
        this.hash = hash;
    }

    public T readFrom(ProtoStreamReader reader) throws IOException {
        AtomicInteger hash = new AtomicInteger(0);
        FieldSetMarshaller<T, AuthenticationTokenConfiguration> marshaller = this.createMarshaller(hash);
        FieldSetReader tokenReader = reader.createFieldSetReader(marshaller, 2);
        AuthenticationTokenConfiguration config = (AuthenticationTokenConfiguration)marshaller.createInitialValue();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index == 1) {
                hash.setPlain(reader.readSFixed32());
                continue;
            }
            if (tokenReader.contains(index)) {
                config = (AuthenticationTokenConfiguration)tokenReader.readField((Object)config);
                continue;
            }
            reader.skipField(tag);
        }
        return (T)((AbstractAuthenticationToken)marshaller.build((Object)config));
    }

    public void writeTo(ProtoStreamWriter writer, T token) throws IOException {
        int hash = this.hash.applyAsInt(token);
        if (hash != 0) {
            writer.writeSFixed32(1, hash);
        }
        writer.createFieldSetWriter(this.createMarshaller(new AtomicInteger(hash)), 2).writeFields(token);
    }

    static <T> T createToken(Class<T> tokenClass, Integer hash, Object principal, Collection<GrantedAuthority> authorities) throws Exception {
        Constructor<T> constructor = tokenClass.getDeclaredConstructor(Integer.class, Object.class, Collection.class);
        constructor.setAccessible(true);
        return constructor.newInstance(hash, principal, authorities);
    }

    public Class<? extends T> getJavaClass() {
        return this.tokenClass;
    }

    private FieldSetMarshaller<T, AuthenticationTokenConfiguration> createMarshaller(final AtomicInteger hash) {
        final Class<T> tokenClass = this.tokenClass;
        return new AuthenticationMarshaller(new Function<AuthenticationTokenConfiguration, T>(){

            @Override
            public T apply(AuthenticationTokenConfiguration config) {
                Object principal = config.getPrincipal();
                List<GrantedAuthority> authorities = config.getAuthorities();
                try {
                    AbstractAuthenticationToken token = (AbstractAuthenticationToken)HashAuthenticationTokenMarshaller.createToken(tokenClass, hash.getPlain(), principal, authorities);
                    token.setDetails(config.getDetails());
                    return token;
                }
                catch (Exception e) {
                    throw new UncheckedIOException(new IOException(e));
                }
            }
        });
    }
}

