/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.security.authentication.jaas;

import java.io.IOException;
import java.security.Principal;
import org.infinispan.protostream.descriptors.WireType;
import org.springframework.security.authentication.jaas.JaasGrantedAuthority;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class JaasGrantedAuthorityMarshaller
implements ProtoStreamMarshaller<JaasGrantedAuthority> {
    private static final int ROLE_INDEX = 1;
    private static final int PRINCIPAL_INDEX = 2;

    public JaasGrantedAuthority readFrom(ProtoStreamReader reader) throws IOException {
        Principal principal = null;
        String role = null;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    role = reader.readString();
                    continue block4;
                }
                case 2: {
                    principal = (Principal)reader.readAny(Principal.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new JaasGrantedAuthority(role, principal);
    }

    public void writeTo(ProtoStreamWriter writer, JaasGrantedAuthority authority) throws IOException {
        Principal principal;
        String role = authority.getAuthority();
        if (role != null) {
            writer.writeString(1, role);
        }
        if ((principal = authority.getPrincipal()) != null) {
            writer.writeAny(2, (Object)principal);
        }
    }

    public Class<? extends JaasGrantedAuthority> getJavaClass() {
        return JaasGrantedAuthority.class;
    }
}

