/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.hotrod;

import java.time.Duration;
import java.util.EnumSet;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingListener;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.SessionRepository;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.CompositeIterable;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.manager.RemoteCacheManager;
import org.wildfly.clustering.infinispan.marshalling.jboss.JBossMarshaller;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.SessionManagerNearCacheFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.clustering.web.spring.DistributableSession;
import org.wildfly.clustering.web.spring.DistributableSessionRepository;
import org.wildfly.clustering.web.spring.ImmutableSessionExpirationListener;
import org.wildfly.clustering.web.spring.SpringSpecificationProvider;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepositoryConfiguration;

public class HotRodSessionRepository
implements SessionRepository<DistributableSession<TransactionBatch>>,
InitializingBean,
DisposableBean,
LocalContextFactory<Void>,
Registrar<String>,
Registration {
    private final HotRodSessionRepositoryConfiguration configuration;
    private volatile RemoteCacheContainer container;
    private volatile SessionManagerFactory<ServletContext, Void, TransactionBatch> managerFactory;
    private volatile SessionManager<Void, TransactionBatch> manager;
    private volatile SessionRepository<DistributableSession<TransactionBatch>> repository;

    public HotRodSessionRepository(HotRodSessionRepositoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws Exception {
        final Integer maxActiveSessions = this.configuration.getMaxActiveSessions();
        ClassLoader managerLoader = HotRodSessionManagerFactory.class.getClassLoader();
        Configuration configuration = new ConfigurationBuilder().withProperties(this.configuration.getProperties()).marshaller((Marshaller)new JBossMarshaller((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(JBossMarshallingVersion.class, (Enum)JBossMarshallingVersion.CURRENT, (Object)managerLoader), managerLoader)).nearCache().mode(NearCacheMode.INVALIDATED).maxEntries(-1).build();
        final SessionAttributePersistenceStrategy strategy = this.configuration.getPersistenceStrategy();
        String configurationName = this.configuration.getConfigurationName();
        final ServletContext context = this.configuration.getServletContext();
        ClassLoader deploymentLoader = this.configuration.getClassLoader();
        String containerName = context.getServletContextName();
        RemoteCacheManager container = new RemoteCacheManager(containerName, configuration, (Registrar)this);
        container.start();
        this.container = container;
        SimpleMarshallingContext marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(JBossMarshallingVersion.class, (Enum)JBossMarshallingVersion.CURRENT, (Object)deploymentLoader), deploymentLoader);
        SimpleMarshalledValueFactory marshalledValueFactory = new SimpleMarshalledValueFactory((MarshallingContext)marshallingContext);
        ServiceLoader<Immutability> loadedImmutability = ServiceLoader.load(Immutability.class, Immutability.class.getClassLoader());
        CompositeImmutability immutability = new CompositeImmutability((Iterable)new CompositeIterable(new Iterable[]{EnumSet.allOf(DefaultImmutability.class), EnumSet.allOf(SessionAttributeImmutability.class), loadedImmutability}));
        HotRodSessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, HttpSessionBindingListener, MarshallingContext, Void> sessionManagerFactoryConfig = new HotRodSessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, HttpSessionBindingListener, MarshallingContext, Void>((MarshalledValueFactory)marshalledValueFactory, (RemoteCacheContainer)container, configurationName, containerName, (Immutability)immutability){
            final /* synthetic */ MarshalledValueFactory val$marshalledValueFactory;
            final /* synthetic */ RemoteCacheContainer val$container;
            final /* synthetic */ String val$configurationName;
            final /* synthetic */ String val$containerName;
            final /* synthetic */ Immutability val$immutability;
            {
                this.val$marshalledValueFactory = marshalledValueFactory;
                this.val$container = remoteCacheContainer;
                this.val$configurationName = string;
                this.val$containerName = string2;
                this.val$immutability = immutability;
            }

            public Integer getMaxActiveSessions() {
                return maxActiveSessions;
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategy;
            }

            public String getDeploymentName() {
                return context.getVirtualServerName() + context.getContextPath();
            }

            public MarshalledValueFactory<MarshallingContext> getMarshalledValueFactory() {
                return this.val$marshalledValueFactory;
            }

            public String getServerName() {
                return context.getVirtualServerName();
            }

            public LocalContextFactory<Void> getLocalContextFactory() {
                return HotRodSessionRepository.this;
            }

            public <K, V> RemoteCache<K, V> getCache() {
                String cacheName = this.getDeploymentName();
                try (RemoteCacheContainer.NearCacheRegistration registration = this.val$container.registerNearCacheFactory(cacheName, (Function)new SessionManagerNearCacheFactory(this.getMaxActiveSessions(), this.getAttributePersistenceStrategy()));){
                    RemoteCache remoteCache = this.val$container.administration().getOrCreateCache(cacheName, this.getConfigurationName());
                    return remoteCache;
                }
            }

            public String getConfigurationName() {
                return this.val$configurationName;
            }

            public String getContainerName() {
                return this.val$containerName;
            }

            public Immutability getImmutability() {
                return this.val$immutability;
            }

            public SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener, HttpSessionBindingListener> getSpecificationProvider() {
                return SpringSpecificationProvider.INSTANCE;
            }
        };
        this.managerFactory = new HotRodSessionManagerFactory((HotRodSessionManagerFactoryConfiguration)sessionManagerFactoryConfig);
        final Supplier<String> factory = this.configuration.getIdentifierFactory();
        IdentifierFactory<String> identifierFactory = new IdentifierFactory<String>(){

            public String createIdentifier() {
                return (String)factory.get();
            }

            public void start() {
            }

            public void stop() {
            }
        };
        ApplicationEventPublisher publisher = this.configuration.getEventPublisher();
        ImmutableSessionExpirationListener expirationListener = new ImmutableSessionExpirationListener(publisher, context);
        SessionManagerConfiguration<ServletContext> sessionManagerConfiguration = new SessionManagerConfiguration<ServletContext>((IdentifierFactory)identifierFactory, (SessionExpirationListener)expirationListener){
            final /* synthetic */ IdentifierFactory val$identifierFactory;
            final /* synthetic */ SessionExpirationListener val$expirationListener;
            {
                this.val$identifierFactory = identifierFactory;
                this.val$expirationListener = sessionExpirationListener;
            }

            public ServletContext getServletContext() {
                return context;
            }

            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }

            public SessionExpirationListener getExpirationListener() {
                return this.val$expirationListener;
            }

            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return null;
            }
        };
        this.manager = this.managerFactory.createSessionManager((SessionManagerConfiguration)sessionManagerConfiguration);
        Duration timeout = Duration.ofMinutes(context.getSessionTimeout());
        Optional<Object> defaultTimeout = Optional.empty();
        try {
            this.manager.setDefaultMaxInactiveInterval(timeout);
        }
        catch (NoSuchMethodError error) {
            defaultTimeout = Optional.of(timeout);
        }
        this.manager.start();
        this.repository = new DistributableSessionRepository(this.manager, defaultTimeout, publisher);
    }

    public void destroy() throws Exception {
        this.manager.stop();
        this.managerFactory.close();
        this.container.stop();
    }

    public Registration register(String name) {
        return this;
    }

    public void close() {
    }

    public Void createLocalContext() {
        return null;
    }

    public DistributableSession<TransactionBatch> createSession() {
        return (DistributableSession)this.repository.createSession();
    }

    public DistributableSession<TransactionBatch> findById(String id) {
        return (DistributableSession)this.repository.findById(id);
    }

    public void deleteById(String id) {
        this.repository.deleteById(id);
    }

    public void save(DistributableSession<TransactionBatch> session) {
        this.repository.save(session);
    }

    static enum JBossMarshallingVersion implements Function<ClassLoader, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(ClassLoader loader) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassTable((ClassTable)new DynamicClassTable(new ClassLoader[]{loader}));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable(new ClassLoader[]{loader}));
                return config;
            }
        };

        static final JBossMarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_1;
        }
    }
}

