/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.hotrod;

import java.net.URI;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.commons.marshall.Marshaller;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.SessionRepository;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.CompositeIterable;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.manager.RemoteCacheManager;
import org.wildfly.clustering.infinispan.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.SessionManagerNearCacheFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.clustering.web.spring.DistributableSession;
import org.wildfly.clustering.web.spring.DistributableSessionRepository;
import org.wildfly.clustering.web.spring.ImmutableSessionExpirationListener;
import org.wildfly.clustering.web.spring.SpringSpecificationProvider;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepositoryConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

public class HotRodSessionRepository
implements SessionRepository<DistributableSession<TransactionBatch>>,
InitializingBean,
DisposableBean,
LocalContextFactory<Void>,
Registrar<String>,
Registration {
    private final HotRodSessionRepositoryConfiguration configuration;
    private volatile RemoteCacheContainer container;
    private volatile SessionManagerFactory<ServletContext, Void, TransactionBatch> managerFactory;
    private volatile SessionManager<Void, TransactionBatch> manager;
    private volatile SessionRepository<DistributableSession<TransactionBatch>> repository;

    public HotRodSessionRepository(HotRodSessionRepositoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws Exception {
        final ServletContext context = this.configuration.getServletContext();
        final String deploymentName = context.getVirtualServerName() + context.getContextPath();
        String templateName = this.configuration.getTemplateName();
        final Integer maxActiveSessions = this.configuration.getMaxActiveSessions();
        final SessionAttributePersistenceStrategy strategy = this.configuration.getPersistenceStrategy();
        ClassLoader containerLoader = WildFlySecurityManager.getClassLoaderPrivileged(HotRodSessionManagerFactory.class);
        URI uri = this.configuration.getUri();
        Configuration configuration = (uri != null ? HotRodURI.create((URI)uri).toConfigurationBuilder() : new ConfigurationBuilder()).withProperties(this.configuration.getProperties()).marshaller((Marshaller)new ProtoStreamMarshaller(containerLoader)).classLoader(containerLoader).build();
        configuration.addRemoteCache(deploymentName, builder -> builder.forceReturnValues(false).nearCacheMode(NearCacheMode.INVALIDATED).transactionMode(TransactionMode.NONE).templateName(templateName));
        RemoteCacheManager container = new RemoteCacheManager(this.getClass().getName(), configuration, (Registrar)this);
        container.start();
        this.container = container;
        ByteBufferMarshaller marshaller = this.configuration.getMarshallerFactory().apply(context.getClassLoader());
        ByteBufferMarshalledValueFactory marshalledValueFactory = new ByteBufferMarshalledValueFactory(marshaller);
        ServiceLoader<Immutability> loadedImmutability = ServiceLoader.load(Immutability.class, Immutability.class.getClassLoader());
        CompositeImmutability immutability = new CompositeImmutability((Iterable)new CompositeIterable(new Iterable[]{EnumSet.allOf(DefaultImmutability.class), EnumSet.allOf(SessionAttributeImmutability.class), loadedImmutability}));
        HotRodSessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, ByteBufferMarshaller, Void> sessionManagerFactoryConfig = new HotRodSessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, ByteBufferMarshaller, Void>((MarshalledValueFactory)marshalledValueFactory, context, (RemoteCacheContainer)container, (Immutability)immutability){
            final /* synthetic */ MarshalledValueFactory val$marshalledValueFactory;
            final /* synthetic */ ServletContext val$context;
            final /* synthetic */ RemoteCacheContainer val$container;
            final /* synthetic */ Immutability val$immutability;
            {
                this.val$marshalledValueFactory = marshalledValueFactory;
                this.val$context = servletContext;
                this.val$container = remoteCacheContainer;
                this.val$immutability = immutability;
            }

            public Integer getMaxActiveSessions() {
                return maxActiveSessions;
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategy;
            }

            public String getDeploymentName() {
                return deploymentName;
            }

            public MarshalledValueFactory<ByteBufferMarshaller> getMarshalledValueFactory() {
                return this.val$marshalledValueFactory;
            }

            public String getServerName() {
                return this.val$context.getVirtualServerName();
            }

            public LocalContextFactory<Void> getLocalContextFactory() {
                return HotRodSessionRepository.this;
            }

            public <K, V> RemoteCache<K, V> getCache() {
                String cacheName = this.getDeploymentName();
                try (RemoteCacheContainer.NearCacheRegistration registration = this.val$container.registerNearCacheFactory(cacheName, (Function)new SessionManagerNearCacheFactory(this.getMaxActiveSessions(), this.getAttributePersistenceStrategy()));){
                    RemoteCache remoteCache = this.val$container.getCache(cacheName);
                    return remoteCache;
                }
            }

            public String getConfigurationName() {
                return null;
            }

            public String getContainerName() {
                return null;
            }

            public Immutability getImmutability() {
                return this.val$immutability;
            }

            public SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener> getSpecificationProvider() {
                return SpringSpecificationProvider.INSTANCE;
            }
        };
        this.managerFactory = new HotRodSessionManagerFactory((HotRodSessionManagerFactoryConfiguration)sessionManagerFactoryConfig);
        final Supplier<String> factory = this.configuration.getIdentifierFactory();
        IdentifierFactory<String> identifierFactory = new IdentifierFactory<String>(){

            public String createIdentifier() {
                return (String)factory.get();
            }

            public void start() {
            }

            public void stop() {
            }
        };
        ApplicationEventPublisher publisher = this.configuration.getEventPublisher();
        ImmutableSessionExpirationListener expirationListener = new ImmutableSessionExpirationListener(publisher, context);
        SessionManagerConfiguration<ServletContext> sessionManagerConfiguration = new SessionManagerConfiguration<ServletContext>((IdentifierFactory)identifierFactory, (SessionExpirationListener)expirationListener){
            final /* synthetic */ IdentifierFactory val$identifierFactory;
            final /* synthetic */ SessionExpirationListener val$expirationListener;
            {
                this.val$identifierFactory = identifierFactory;
                this.val$expirationListener = sessionExpirationListener;
            }

            public ServletContext getServletContext() {
                return context;
            }

            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }

            public SessionExpirationListener getExpirationListener() {
                return this.val$expirationListener;
            }

            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return null;
            }
        };
        this.manager = this.managerFactory.createSessionManager((SessionManagerConfiguration)sessionManagerConfiguration);
        Duration timeout = Duration.ofMinutes(context.getSessionTimeout());
        Optional<Object> defaultTimeout = Optional.empty();
        try {
            this.manager.setDefaultMaxInactiveInterval(timeout);
        }
        catch (NoSuchMethodError error) {
            defaultTimeout = Optional.of(timeout);
        }
        this.manager.start();
        this.repository = new DistributableSessionRepository(this.manager, defaultTimeout, publisher, context);
    }

    public void destroy() throws Exception {
        this.manager.stop();
        this.managerFactory.close();
        this.container.stop();
    }

    public Registration register(String name) {
        return this;
    }

    public void close() {
    }

    public Void createLocalContext() {
        return null;
    }

    public DistributableSession<TransactionBatch> createSession() {
        return (DistributableSession)this.repository.createSession();
    }

    public DistributableSession<TransactionBatch> findById(String id) {
        return (DistributableSession)this.repository.findById(id);
    }

    public void deleteById(String id) {
        this.repository.deleteById(id);
    }

    public void save(DistributableSession<TransactionBatch> session) {
        this.repository.save(session);
    }
}

