/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.hotrod.annotation;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.spring.SessionMarshallerFactory;
import org.wildfly.clustering.web.spring.SessionPersistenceGranularity;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepository;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepositoryConfiguration;
import org.wildfly.clustering.web.spring.hotrod.annotation.EnableHotRodHttpSession;
import org.wildfly.common.Assert;

@Configuration(proxyBeanMethods=false)
public class HotRodHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements HotRodSessionRepositoryConfiguration,
ServletContextAware,
ApplicationEventPublisherAware,
ImportAware {
    private URI uri;
    private Properties properties = new Properties();
    private Integer maxActiveSessions = null;
    private SessionAttributePersistenceStrategy persistenceStrategy = SessionAttributePersistenceStrategy.COARSE;
    private Function<ClassLoader, ByteBufferMarshaller> marshallerFactory = SessionMarshallerFactory.JBOSS;
    private String templateName = DefaultTemplate.DIST_SYNC.getTemplateName();
    private Supplier<String> identifierFactory = () -> UUID.randomUUID().toString();
    private ApplicationEventPublisher publisher;
    private ServletContext context;

    @Bean
    public HotRodSessionRepository sessionRepository() {
        Assert.assertNotNull((Object)this.properties);
        Assert.assertNotNull((Object)this.persistenceStrategy);
        Assert.assertNotNull((Object)this.publisher);
        Assert.assertNotNull((Object)this.context);
        return new HotRodSessionRepository(this);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public Integer getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    @Override
    public SessionAttributePersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    @Override
    public Function<ClassLoader, ByteBufferMarshaller> getMarshallerFactory() {
        return this.marshallerFactory;
    }

    @Override
    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    @Override
    public ApplicationEventPublisher getEventPublisher() {
        return this.publisher;
    }

    @Override
    public ServletContext getServletContext() {
        return this.context;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void setServletContext(ServletContext context) {
        super.setServletContext(context);
        this.context = context;
    }

    @Autowired(required=false)
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Autowired(required=false)
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Autowired(required=false)
    public void setGranularity(SessionPersistenceGranularity granularity) {
        this.persistenceStrategy = granularity.get();
    }

    @Autowired(required=false)
    public void setPersistenceStrategy(SessionAttributePersistenceStrategy persistenceStrategy) {
        this.persistenceStrategy = persistenceStrategy;
    }

    @Autowired(required=false)
    public void setMarshallerFactory(Function<ClassLoader, ByteBufferMarshaller> marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
    }

    @Autowired(required=false)
    public void setMaxActiveSessions(Integer maxActiveSessions) {
        this.maxActiveSessions = maxActiveSessions;
    }

    @Autowired(required=false)
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Autowired(required=false)
    public void setIdentifierFactory(Supplier<String> identifierFactory) {
        this.identifierFactory = identifierFactory;
    }

    public void setImportMetadata(AnnotationMetadata metadata) {
        Map attributeMap = metadata.getAnnotationAttributes(EnableHotRodHttpSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        String uriValue = attributes.getString("uri");
        this.setUri(StringUtils.hasText((String)uriValue) ? URI.create(uriValue) : null);
        int maxActiveSessions = attributes.getNumber("maxActiveSessions").intValue();
        this.setMaxActiveSessions(maxActiveSessions < 0 ? null : Integer.valueOf(maxActiveSessions));
        this.setMarshallerFactory((Function)((Object)attributes.getEnum("marshallerFactory")));
        this.setGranularity((SessionPersistenceGranularity)attributes.getEnum("granularity"));
        this.setTemplateName(attributes.getString("templateName"));
    }
}

