/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.session.infinispan.embedded.config;

import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.session.IndexResolver;
import org.springframework.session.Session;
import org.springframework.util.StringValueResolver;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionProvider;
import org.wildfly.clustering.spring.context.infinispan.embedded.EmbeddedCacheManagerBean;
import org.wildfly.clustering.spring.context.infinispan.embedded.InfinispanConfiguration;
import org.wildfly.clustering.spring.context.infinispan.embedded.InfinispanSessionManagerFactoryBean;
import org.wildfly.clustering.spring.context.infinispan.embedded.MutableInfinispanConfiguration;
import org.wildfly.clustering.spring.context.infinispan.embedded.config.InfinispanConfigurationBean;
import org.wildfly.clustering.spring.session.config.HttpSessionConfiguration;

public class AbstractInfinispanHttpSessionConfiguration
extends HttpSessionConfiguration
implements MutableInfinispanConfiguration {
    private final MutableInfinispanConfiguration configuration = new InfinispanConfigurationBean();

    protected AbstractInfinispanHttpSessionConfiguration(Class<? extends Annotation> annotationClass, Map<String, String> defaultIndexes, IndexResolver<Session> defaultIndexResolver) {
        super(annotationClass, defaultIndexes, defaultIndexResolver);
    }

    @Bean
    public ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration embeddedCacheManagerConfiguration() {
        return new EmbeddedCacheManagerBean((InfinispanConfiguration)this);
    }

    @Bean
    public SessionManagerFactory<ServletContext, Void, TransactionBatch> sessionManagerFactory(ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration embeddedCacheManagerConfiguration) {
        return new InfinispanSessionManagerFactoryBean((SessionManagerFactoryConfiguration)this, (SessionSpecificationProvider)HttpSessionProvider.INSTANCE, (SessionEventListenerSpecificationProvider)HttpSessionActivationListenerProvider.INSTANCE, (InfinispanConfiguration)this.configuration, embeddedCacheManagerConfiguration);
    }

    public String getConfigurationResource() {
        return this.configuration.getConfigurationResource();
    }

    public String getTemplateName() {
        return this.configuration.getTemplateName();
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.configuration.setEmbeddedValueResolver(resolver);
    }

    @Autowired(required=false)
    public void setResource(String resource) {
        this.configuration.setResource(resource);
    }

    @Autowired(required=false)
    public void setTemplate(String templateName) {
        this.configuration.setTemplate(templateName);
    }

    public void accept(AnnotationAttributes attributes) {
        super.accept(attributes);
        this.configuration.accept((Object)attributes);
    }
}

