/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.infinispan;

import io.reactivex.rxjava3.schedulers.Schedulers;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import java.io.FileNotFoundException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.jmx.JmxConfigurator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.IndexResolver;
import org.springframework.session.Session;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.affinity.impl.DefaultKeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.infinispan.marshall.InfinispanProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.SimpleClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.server.NodeFactory;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.LocalCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.group.CacheGroup;
import org.wildfly.clustering.server.infinispan.group.CacheGroupConfiguration;
import org.wildfly.clustering.server.infinispan.group.LocalGroup;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.metadata.SessionMetaDataKey;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.clustering.web.spring.DistributableSessionRepository;
import org.wildfly.clustering.web.spring.DistributableSessionRepositoryConfiguration;
import org.wildfly.clustering.web.spring.ImmutableSessionDestroyAction;
import org.wildfly.clustering.web.spring.ImmutableSessionExpirationListener;
import org.wildfly.clustering.web.spring.IndexingConfiguration;
import org.wildfly.clustering.web.spring.JakartaSessionManagerConfiguration;
import org.wildfly.clustering.web.spring.SessionMarshallerFactory;
import org.wildfly.clustering.web.spring.SpringSession;
import org.wildfly.clustering.web.spring.SpringSpecificationProvider;
import org.wildfly.clustering.web.spring.infinispan.DefaultNonBlockingThreadFactory;
import org.wildfly.clustering.web.spring.infinispan.ForkChannelConfigurator;
import org.wildfly.clustering.web.spring.infinispan.InfinispanSessionRepositoryConfiguration;
import org.wildfly.clustering.web.spring.infinispan.JChannelConfigurator;
import org.wildfly.clustering.web.spring.security.SpringSecurityImmutability;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.common.iteration.CompositeIterable;
import org.wildfly.security.manager.WildFlySecurityManager;

public class InfinispanSessionRepository
implements FindByIndexNameSessionRepository<SpringSession>,
InitializingBean,
DisposableBean,
Registrar<String>,
Registration {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final InfinispanSessionRepositoryConfiguration configuration;
    private final List<Runnable> stopTasks = new LinkedList<Runnable>();
    private volatile FindByIndexNameSessionRepository<SpringSession> repository;

    public InfinispanSessionRepository(InfinispanSessionRepositoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws Exception {
        Configuration template;
        ChannelCommandDispatcherFactory dispatcherFactory;
        JChannel channel;
        final ServletContext context = this.configuration.getServletContext();
        final String deploymentName = context.getVirtualServerName() + context.getContextPath();
        String resourceName = this.configuration.getConfigurationResource();
        String templateName = this.configuration.getTemplateName();
        final Integer maxActiveSessions = this.configuration.getMaxActiveSessions();
        final SessionAttributePersistenceStrategy strategy = this.configuration.getPersistenceStrategy();
        COUNTER.incrementAndGet();
        this.stopTasks.add(() -> {
            if (COUNTER.decrementAndGet() == 0) {
                Schedulers.shutdown();
            }
        });
        final ClassLoader containerLoader = WildFlySecurityManager.getClassLoaderPrivileged(InfinispanSessionManagerFactory.class);
        URL url = context.getResource(resourceName);
        if (url == null) {
            throw new FileNotFoundException(resourceName);
        }
        ConfigurationBuilderHolder holder = new ParserRegistry().parse(url);
        GlobalConfigurationBuilder global = holder.getGlobalConfigurationBuilder();
        String containerName = global.cacheContainer().name();
        final TransportConfiguration transport = global.transport().create();
        JChannelConfigurator configurator = transport.transport() != null ? new JChannelConfigurator(context, transport) : null;
        JChannel jChannel = channel = configurator != null ? configurator.createChannel(null) : null;
        if (channel != null) {
            channel.setName(transport.nodeName());
            channel.setDiscardOwnMessages(true);
            channel.connect(transport.clusterName());
            this.stopTasks.add(() -> ((JChannel)channel).close());
            GlobalJmxConfiguration jmx = global.jmx().create();
            if (jmx.enabled()) {
                ObjectName prefix = new ObjectName(jmx.domain(), "manager", ObjectName.quote(containerName));
                JmxConfigurator.registerChannel((JChannel)channel, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ObjectName)prefix, (String)transport.clusterName(), (boolean)true);
                this.stopTasks.add(() -> {
                    try {
                        JmxConfigurator.unregisterChannel((JChannel)channel, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ObjectName)prefix, (String)transport.clusterName());
                    }
                    catch (Exception e) {
                        context.log(e.getLocalizedMessage(), (Throwable)e);
                    }
                });
            }
            Properties properties = new Properties();
            properties.put("channelConfigurator", new ForkChannelConfigurator(channel, containerName));
            global.transport().withProperties(properties);
        }
        final Function marshallerFactory = this.configuration.getMarshallerFactory();
        ChannelCommandDispatcherFactory channelDispatcherFactory = channel != null ? new ChannelCommandDispatcherFactory(new ChannelCommandDispatcherFactoryConfiguration(){

            public JChannel getChannel() {
                return channel;
            }

            public ByteBufferMarshaller getMarshaller() {
                return (ByteBufferMarshaller)SessionMarshallerFactory.PROTOSTREAM.apply((Object)containerLoader);
            }

            public Duration getTimeout() {
                return Duration.ofMillis(transport.initialClusterTimeout());
            }

            public Function<ClassLoader, ByteBufferMarshaller> getMarshallerFactory() {
                return marshallerFactory;
            }

            public Predicate<Message> getUnknownForkPredicate() {
                return Predicate.not(Message::hasPayload);
            }
        }) : null;
        LocalGroup localGroup = new LocalGroup(transport.nodeName(), transport.clusterName());
        Object object = dispatcherFactory = channelDispatcherFactory != null ? channelDispatcherFactory : new LocalCommandDispatcherFactory((org.wildfly.clustering.group.Group)localGroup);
        if (channelDispatcherFactory != null) {
            this.stopTasks.add(() -> ((ChannelCommandDispatcherFactory)channelDispatcherFactory).close());
        }
        holder.getGlobalConfigurationBuilder().classLoader(containerLoader).blockingThreadPool().threadFactory((ThreadFactory)new DefaultThreadFactory(BlockingManager.class)).expirationThreadPool().threadFactory((ThreadFactory)new DefaultThreadFactory(ExpirationManager.class)).listenerThreadPool().threadFactory((ThreadFactory)new DefaultThreadFactory(ListenerInvocation.class)).nonBlockingThreadPool().threadFactory((ThreadFactory)((Object)new DefaultNonBlockingThreadFactory(NonBlockingManager.class))).serialization().marshaller((Marshaller)new InfinispanProtoStreamMarshaller((ClassLoaderMarshaller)new SimpleClassLoaderMarshaller(containerLoader), builder -> builder.load(containerLoader))).addContextInitializer(new SerializationContextInitializer(){

            @Deprecated
            public String getProtoFile() {
                return null;
            }

            @Deprecated
            public String getProtoFileName() {
                return null;
            }

            public void registerMarshallers(SerializationContext context) {
            }

            public void registerSchema(SerializationContext context) {
            }
        }).globalState().configurationStorage(ConfigurationStorage.IMMUTABLE).disable();
        DefaultCacheManager container = new DefaultCacheManager(holder, false);
        Configuration configuration = template = templateName != null ? container.getCacheConfiguration(templateName) : container.getDefaultCacheConfiguration();
        if (template == null) {
            if (templateName == null) {
                throw new IllegalArgumentException("Infinispan configuration does not define a default cache");
            }
            throw new IllegalArgumentException(String.format("No such configuration template: %s", templateName));
        }
        ConfigurationBuilder builder2 = new ConfigurationBuilder().read(template).template(false);
        builder2.encoding().mediaType("application/x-java-object");
        builder2.clustering().hash().groups().enabled();
        ExpirationConfiguration expiration = builder2.expiration().create();
        if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
            builder2.expiration().lifespan(-1L).maxIdle(-1L);
        }
        EvictionStrategy eviction = maxActiveSessions != null ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL;
        builder2.memory().storage(StorageType.HEAP).whenFull(eviction).maxCount(maxActiveSessions != null ? maxActiveSessions.longValue() : -1L);
        if (eviction.isEnabled()) {
            ((DataContainerConfigurationBuilder)builder2.addModule(DataContainerConfigurationBuilder.class)).evictable(SessionMetaDataKey.class::isInstance);
        }
        container.defineConfiguration(deploymentName, builder2.build());
        this.stopTasks.add(() -> InfinispanSessionRepository.lambda$afterPropertiesSet$3((EmbeddedCacheManager)container, deploymentName));
        container.start();
        this.stopTasks.add(() -> ((EmbeddedCacheManager)container).stop());
        ClassLoader loader = context.getClassLoader();
        final ByteBufferMarshaller marshaller = (ByteBufferMarshaller)marshallerFactory.apply(loader);
        LinkedList<Immutability> loadedImmutabilities = new LinkedList<Immutability>();
        for (Immutability loadedImmutability : ServiceLoader.load(Immutability.class, loader)) {
            loadedImmutabilities.add(loadedImmutability);
        }
        CompositeImmutability immutability = new CompositeImmutability((Iterable)new CompositeIterable(new Iterable[]{EnumSet.allOf(DefaultImmutability.class), EnumSet.allOf(SessionAttributeImmutability.class), EnumSet.allOf(SpringSecurityImmutability.class), loadedImmutabilities}));
        final Supplier identifierFactory = this.configuration.getIdentifierFactory();
        DefaultKeyAffinityServiceFactory affinityFactory = new DefaultKeyAffinityServiceFactory();
        Map indexes = this.configuration.getIndexes();
        final HashMap<String, SSOManager> managers = indexes.isEmpty() ? Collections.emptyMap() : new HashMap<String, SSOManager>();
        for (Map.Entry entry : indexes.entrySet()) {
            String cacheName = String.format("%s/%s", deploymentName, entry.getKey());
            String indexName = (String)entry.getValue();
            container.defineConfiguration(cacheName, builder2.build());
            this.stopTasks.add(() -> InfinispanSessionRepository.lambda$afterPropertiesSet$4((EmbeddedCacheManager)container, cacheName));
            Cache cache = container.getCache(cacheName);
            cache.start();
            this.stopTasks.add(() -> ((Cache)cache).stop());
            InfinispanSSOManagerFactory ssoManagerFactory = new InfinispanSSOManagerFactory(new InfinispanSSOManagerFactoryConfiguration(){
                final /* synthetic */ EmbeddedCacheManager val$container;
                final /* synthetic */ String val$cacheName;
                final /* synthetic */ KeyAffinityServiceFactory val$affinityFactory;
                {
                    this.val$container = embeddedCacheManager;
                    this.val$cacheName = string;
                    this.val$affinityFactory = keyAffinityServiceFactory;
                }

                public <K, V> Cache<K, V> getCache() {
                    return this.val$container.getCache(this.val$cacheName);
                }

                public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
                    return this.val$affinityFactory;
                }
            });
            SSOManager ssoManager = ssoManagerFactory.createSSOManager((SSOManagerConfiguration)new SSOManagerConfiguration<Void>(){

                public Supplier<String> getIdentifierFactory() {
                    return identifierFactory;
                }

                public ByteBufferMarshaller getMarshaller() {
                    return marshaller;
                }

                public Supplier<Void> getLocalContextFactory() {
                    return Functions.constantSupplier(null);
                }
            });
            managers.put(indexName, ssoManager);
        }
        final IndexResolver resolver = this.configuration.getIndexResolver();
        IndexingConfiguration<TransactionBatch> indexing = new IndexingConfiguration<TransactionBatch>(){

            public Map<String, SSOManager<Void, String, String, Void, TransactionBatch>> getSSOManagers() {
                return managers;
            }

            public IndexResolver<Session> getIndexResolver() {
                return resolver;
            }
        };
        final Cache cache = container.getCache(deploymentName);
        cache.start();
        this.stopTasks.add(() -> ((Cache)cache).stop());
        ChannelCommandDispatcherFactory memberFactory = channelDispatcherFactory != null ? channelDispatcherFactory : arg_0 -> InfinispanSessionRepository.lambda$afterPropertiesSet$5((Group)localGroup, arg_0);
        CacheGroup group = new CacheGroup(new CacheGroupConfiguration(){
            final /* synthetic */ NodeFactory val$memberFactory;
            {
                this.val$memberFactory = nodeFactory;
            }

            public <K, V> Cache<K, V> getCache() {
                return cache;
            }

            public NodeFactory<Address> getMemberFactory() {
                return this.val$memberFactory;
            }
        });
        this.stopTasks.add(() -> ((CacheGroup)group).close());
        InfinispanSessionManagerFactory managerFactory = new InfinispanSessionManagerFactory((InfinispanSessionManagerFactoryConfiguration)new InfinispanSessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, Void>(){
            final /* synthetic */ EmbeddedCacheManager val$container;
            final /* synthetic */ Immutability val$immutability;
            final /* synthetic */ CommandDispatcherFactory val$dispatcherFactory;
            final /* synthetic */ KeyAffinityServiceFactory val$affinityFactory;
            final /* synthetic */ CacheGroup val$group;
            {
                this.val$container = embeddedCacheManager;
                this.val$immutability = immutability;
                this.val$dispatcherFactory = commandDispatcherFactory;
                this.val$affinityFactory = keyAffinityServiceFactory;
                this.val$group = cacheGroup;
            }

            public Integer getMaxActiveSessions() {
                return maxActiveSessions;
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategy;
            }

            public String getDeploymentName() {
                return deploymentName;
            }

            public ByteBufferMarshaller getMarshaller() {
                return marshaller;
            }

            public String getServerName() {
                return context.getVirtualServerName();
            }

            public Supplier<Void> getLocalContextFactory() {
                return Functions.constantSupplier(null);
            }

            public <K, V> Cache<K, V> getCache() {
                return this.val$container.getCache(this.getDeploymentName());
            }

            public Immutability getImmutability() {
                return this.val$immutability;
            }

            public SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener> getSpecificationProvider() {
                return SpringSpecificationProvider.INSTANCE;
            }

            public CommandDispatcherFactory getCommandDispatcherFactory() {
                return this.val$dispatcherFactory;
            }

            public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
                return this.val$affinityFactory;
            }

            public NodeFactory<org.infinispan.remoting.transport.Address> getMemberFactory() {
                return this.val$group;
            }
        });
        this.stopTasks.add(() -> ((SessionManagerFactory)managerFactory).close());
        final ApplicationEventPublisher publisher = this.configuration.getEventPublisher();
        ImmutableSessionDestroyAction sessionDestroyAction = new ImmutableSessionDestroyAction(publisher, context, (IndexingConfiguration)indexing);
        ImmutableSessionExpirationListener expirationListener = new ImmutableSessionExpirationListener(context, (BiConsumer)sessionDestroyAction);
        JakartaSessionManagerConfiguration managerConfiguration = new JakartaSessionManagerConfiguration(){
            final /* synthetic */ Consumer val$expirationListener;
            {
                this.val$expirationListener = consumer;
            }

            public ServletContext getServletContext() {
                return context;
            }

            public Supplier<String> getIdentifierFactory() {
                return identifierFactory;
            }

            public Consumer<ImmutableSession> getExpirationListener() {
                return this.val$expirationListener;
            }
        };
        final SessionManager manager = managerFactory.createSessionManager((SessionManagerConfiguration)managerConfiguration);
        manager.start();
        this.stopTasks.add(() -> ((SessionManager)manager).stop());
        this.repository = new DistributableSessionRepository((DistributableSessionRepositoryConfiguration)new DistributableSessionRepositoryConfiguration<TransactionBatch>(){
            final /* synthetic */ BiConsumer val$sessionDestroyAction;
            final /* synthetic */ IndexingConfiguration val$indexing;
            {
                this.val$sessionDestroyAction = biConsumer;
                this.val$indexing = indexingConfiguration;
            }

            public SessionManager<Void, TransactionBatch> getSessionManager() {
                return manager;
            }

            public ApplicationEventPublisher getEventPublisher() {
                return publisher;
            }

            public BiConsumer<ImmutableSession, BiFunction<Object, Session, ApplicationEvent>> getSessionDestroyAction() {
                return this.val$sessionDestroyAction;
            }

            public IndexingConfiguration<TransactionBatch> getIndexingConfiguration() {
                return this.val$indexing;
            }
        });
    }

    public void destroy() {
        ListIterator<Runnable> tasks = this.stopTasks.listIterator(this.stopTasks.size() - 1);
        while (tasks.hasPrevious()) {
            tasks.previous().run();
        }
    }

    public Registration register(String name) {
        return this;
    }

    public void close() {
    }

    public SpringSession createSession() {
        return (SpringSession)this.repository.createSession();
    }

    public SpringSession findById(String id) {
        return (SpringSession)this.repository.findById(id);
    }

    public void deleteById(String id) {
        this.repository.deleteById(id);
    }

    public void save(SpringSession session) {
        this.repository.save((Session)session);
    }

    public Map<String, SpringSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        return this.repository.findByIndexNameAndIndexValue(indexName, indexValue);
    }

    private static /* synthetic */ Node lambda$afterPropertiesSet$5(Group localGroup, Address address) {
        return localGroup.createNode(null);
    }

    private static /* synthetic */ void lambda$afterPropertiesSet$4(EmbeddedCacheManager container, String cacheName) {
        container.undefineConfiguration(cacheName);
    }

    private static /* synthetic */ void lambda$afterPropertiesSet$3(EmbeddedCacheManager container, String deploymentName) {
        container.undefineConfiguration(deploymentName);
    }
}

