/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.web.infinispan.embedded.config;

import jakarta.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.StringValueResolver;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.spring.context.infinispan.embedded.EmbeddedCacheManagerBean;
import org.wildfly.clustering.spring.context.infinispan.embedded.InfinispanConfiguration;
import org.wildfly.clustering.spring.context.infinispan.embedded.InfinispanSessionManagerFactoryBean;
import org.wildfly.clustering.spring.context.infinispan.embedded.MutableInfinispanConfiguration;
import org.wildfly.clustering.spring.context.infinispan.embedded.config.InfinispanConfigurationBean;
import org.wildfly.clustering.spring.web.config.WebSessionConfiguration;
import org.wildfly.clustering.spring.web.infinispan.embedded.config.annotation.EnableInfinispanWebSession;

@Configuration(proxyBeanMethods=false)
public class InfinispanWebSessionConfiguration
extends WebSessionConfiguration
implements MutableInfinispanConfiguration {
    private final MutableInfinispanConfiguration configuration = new InfinispanConfigurationBean();

    public InfinispanWebSessionConfiguration() {
        super(EnableInfinispanWebSession.class);
    }

    @Bean
    public ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration embeddedCacheManagerConfiguration() {
        return new EmbeddedCacheManagerBean((InfinispanConfiguration)this);
    }

    @Bean
    public SessionManagerFactory<ServletContext, Void, TransactionBatch> sessionManagerFactory(ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration embeddedCacheManagerConfiguration) {
        return new InfinispanSessionManagerFactoryBean((SessionManagerFactoryConfiguration)this, this.get(), (InfinispanConfiguration)this.configuration, embeddedCacheManagerConfiguration);
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.configuration.setEmbeddedValueResolver(resolver);
    }

    @Autowired(required=false)
    public void setConfigurationResource(String resource) {
        this.configuration.setConfigurationResource(resource);
    }

    @Autowired(required=false)
    public void setTemplateName(String templateName) {
        this.configuration.setTemplateName(templateName);
    }

    public String getConfigurationResource() {
        return this.configuration.getConfigurationResource();
    }

    public String getTemplateName() {
        return this.configuration.getTemplateName();
    }

    public void accept(AnnotationAttributes attributes) {
        this.configuration.accept((Object)attributes);
    }
}

