/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.web.infinispan.remote.config;

import jakarta.servlet.ServletContext;
import java.net.URI;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.StringValueResolver;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.spring.context.infinispan.remote.HotRodConfiguration;
import org.wildfly.clustering.spring.context.infinispan.remote.HotRodSessionManagerFactoryBean;
import org.wildfly.clustering.spring.context.infinispan.remote.MutableHotRodConfiguration;
import org.wildfly.clustering.spring.context.infinispan.remote.RemoteCacheContainerProvider;
import org.wildfly.clustering.spring.context.infinispan.remote.RemoteCacheContainerProviderBean;
import org.wildfly.clustering.spring.context.infinispan.remote.config.HotRodConfigurationBean;
import org.wildfly.clustering.spring.web.config.WebSessionConfiguration;
import org.wildfly.clustering.spring.web.infinispan.remote.config.annotation.EnableHotRodWebSession;

@Configuration(proxyBeanMethods=false)
public class HotRodWebSessionConfiguration
extends WebSessionConfiguration
implements MutableHotRodConfiguration {
    private final MutableHotRodConfiguration configuration = new HotRodConfigurationBean();

    public HotRodWebSessionConfiguration() {
        super(EnableHotRodWebSession.class);
    }

    @Bean
    public RemoteCacheContainerProvider remoteCacheManagerProvider() {
        return new RemoteCacheContainerProviderBean((HotRodConfiguration)this);
    }

    @Bean
    public SessionManagerFactory<ServletContext, Void, TransactionBatch> sessionManagerFactory(RemoteCacheContainerProvider provider) {
        return new HotRodSessionManagerFactoryBean((SessionManagerFactoryConfiguration)this, this.get(), (HotRodConfiguration)this.configuration, provider);
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.configuration.setEmbeddedValueResolver(resolver);
    }

    public URI getUri() {
        return this.configuration.getUri();
    }

    public Properties getProperties() {
        return this.configuration.getProperties();
    }

    public String getTemplateName() {
        return this.configuration.getTemplateName();
    }

    @Autowired(required=false)
    public void setUri(String uri) {
        this.configuration.setUri(uri);
    }

    public void setProperty(String name, String value) {
        this.configuration.setProperty(name, value);
    }

    @Autowired(required=false)
    public void setTemplateName(String templateName) {
        this.configuration.setTemplateName(templateName);
    }

    public void accept(AnnotationAttributes attributes) {
        this.configuration.accept((Object)attributes);
    }
}

