/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.catalina.Context;
import org.wildfly.clustering.context.ContextClassLoaderReference;
import org.wildfly.clustering.context.ContextReference;
import org.wildfly.clustering.context.ContextReferenceExecutor;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionDestroyAction;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionExpirationListener;

public class CatalinaSessionExpirationListener
implements SessionExpirationListener {
    private final Consumer<ImmutableSession> expireAction;
    private final Executor executor;

    public CatalinaSessionExpirationListener(Context context) {
        this.expireAction = new CatalinaSessionDestroyAction(context);
        this.executor = new ContextReferenceExecutor((Object)context.getLoader().getClassLoader(), (ContextReference)ContextClassLoaderReference.INSTANCE);
    }

    public void sessionExpired(ImmutableSession session) {
        this.executor.execute(() -> this.expireAction.accept(session));
    }
}

