/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.hotrod;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.marshall.Marshaller;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.CompositeIterable;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.manager.RemoteCacheManager;
import org.wildfly.clustering.infinispan.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.tomcat.SessionMarshallerFactory;
import org.wildfly.clustering.tomcat.SessionPersistenceGranularity;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionExpirationListener;
import org.wildfly.clustering.tomcat.catalina.CatalinaSpecificationProvider;
import org.wildfly.clustering.tomcat.catalina.DistributableManager;
import org.wildfly.clustering.tomcat.catalina.IdentifierFactoryAdapter;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContext;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContextFactory;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.SessionManagerNearCacheFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public class HotRodManager
extends ManagerBase
implements Registrar<String> {
    private final Properties properties = new Properties();
    private volatile RemoteCacheContainer container;
    private volatile SessionManagerFactory<ServletContext, LocalSessionContext, TransactionBatch> managerFactory;
    private volatile CatalinaManager<TransactionBatch> manager;
    private volatile SessionAttributePersistenceStrategy persistenceStrategy = SessionPersistenceGranularity.SESSION.get();
    private volatile SessionMarshallerFactory marshallerFactory = SessionMarshallerFactory.JBOSS;
    private volatile String templateName = DefaultTemplate.DIST_SYNC.getTemplateName();
    private volatile URI uri = null;

    public void setUri(String uri) {
        this.uri = URI.create(uri);
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty("infinispan.client.hotrod." + name, value);
    }

    public void setPersistenceStrategy(SessionAttributePersistenceStrategy strategy) {
        this.persistenceStrategy = strategy;
    }

    public void setGranularity(SessionPersistenceGranularity granularity) {
        this.setPersistenceStrategy(granularity.get());
    }

    public void setGranularity(String granularity) {
        this.setGranularity(SessionPersistenceGranularity.valueOf((String)granularity));
    }

    public void setTemplate(String templateName) {
        this.templateName = templateName;
    }

    public void setMarshallerFactory(SessionMarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
    }

    public void setMarshaller(String marshallerFactory) {
        this.setMarshallerFactory(SessionMarshallerFactory.valueOf((String)marshallerFactory));
    }

    @Deprecated
    public void setPersistenceStrategy(String strategy) {
        this.setPersistenceStrategy(SessionAttributePersistenceStrategy.valueOf((String)strategy));
    }

    @Deprecated
    public void setConfigurationName(String configurationName) {
        this.setTemplate(configurationName);
    }

    public Registration register(String cacheName) {
        return () -> {};
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        Context context = this.getContext();
        Host host = (Host)context.getParent();
        Engine engine = (Engine)host.getParent();
        final String deploymentName = host.getName() + context.getName();
        final Integer maxActiveSessions = this.getMaxActiveSessions() >= 0 ? Integer.valueOf(this.getMaxActiveSessions()) : null;
        final SessionAttributePersistenceStrategy strategy = this.persistenceStrategy;
        ClassLoader containerLoader = WildFlySecurityManager.getClassLoaderPrivileged(HotRodSessionManagerFactory.class);
        Configuration configuration = Optional.ofNullable(this.uri).map(HotRodURI::create).map(HotRodURI::toConfigurationBuilder).orElseGet(ConfigurationBuilder::new).withProperties(this.properties).marshaller((Marshaller)new ProtoStreamMarshaller(containerLoader)).classLoader(containerLoader).build();
        configuration.addRemoteCache(deploymentName, builder -> builder.forceReturnValues(false).nearCacheMode(NearCacheMode.INVALIDATED).transactionMode(TransactionMode.NONE).templateName(this.templateName));
        RemoteCacheManager container = new RemoteCacheManager(((Object)((Object)this)).getClass().getName(), configuration, (Registrar)this);
        container.start();
        this.container = container;
        ClassLoader loader = context.getLoader().getClassLoader();
        ByteBufferMarshaller marshaller = (ByteBufferMarshaller)this.marshallerFactory.apply((Object)loader);
        ByteBufferMarshalledValueFactory marshalledValueFactory = new ByteBufferMarshalledValueFactory(marshaller);
        LocalSessionContextFactory localContextFactory = new LocalSessionContextFactory();
        ServiceLoader<Immutability> loadedImmutability = ServiceLoader.load(Immutability.class, Immutability.class.getClassLoader());
        CompositeImmutability immutability = new CompositeImmutability((Iterable)new CompositeIterable(new Iterable[]{EnumSet.allOf(DefaultImmutability.class), EnumSet.allOf(SessionAttributeImmutability.class), loadedImmutability}));
        HotRodSessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, ByteBufferMarshaller, LocalSessionContext> sessionManagerFactoryConfig = new HotRodSessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, ByteBufferMarshaller, LocalSessionContext>((MarshalledValueFactory)marshalledValueFactory, engine, (LocalContextFactory)localContextFactory, (RemoteCacheContainer)container, (Immutability)immutability){
            final /* synthetic */ MarshalledValueFactory val$marshalledValueFactory;
            final /* synthetic */ Engine val$engine;
            final /* synthetic */ LocalContextFactory val$localContextFactory;
            final /* synthetic */ RemoteCacheContainer val$container;
            final /* synthetic */ Immutability val$immutability;
            {
                this.val$marshalledValueFactory = marshalledValueFactory;
                this.val$engine = engine;
                this.val$localContextFactory = localContextFactory;
                this.val$container = remoteCacheContainer;
                this.val$immutability = immutability;
            }

            public Integer getMaxActiveSessions() {
                return maxActiveSessions;
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategy;
            }

            public String getDeploymentName() {
                return deploymentName;
            }

            public MarshalledValueFactory<ByteBufferMarshaller> getMarshalledValueFactory() {
                return this.val$marshalledValueFactory;
            }

            public String getServerName() {
                return this.val$engine.getService().getName();
            }

            public LocalContextFactory<LocalSessionContext> getLocalContextFactory() {
                return this.val$localContextFactory;
            }

            public <K, V> RemoteCache<K, V> getCache() {
                String cacheName = this.getDeploymentName();
                try (RemoteCacheContainer.NearCacheRegistration registration = this.val$container.registerNearCacheFactory(cacheName, (Function)new SessionManagerNearCacheFactory(this.getMaxActiveSessions(), this.getAttributePersistenceStrategy()));){
                    RemoteCache remoteCache = this.val$container.getCache(cacheName);
                    return remoteCache;
                }
            }

            public String getConfigurationName() {
                return null;
            }

            public String getContainerName() {
                return null;
            }

            public Immutability getImmutability() {
                return this.val$immutability;
            }

            public SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener> getSpecificationProvider() {
                return CatalinaSpecificationProvider.INSTANCE;
            }
        };
        this.managerFactory = new HotRodSessionManagerFactory((HotRodSessionManagerFactoryConfiguration)sessionManagerFactoryConfig);
        final ServletContext servletContext = context.getServletContext();
        CatalinaSessionExpirationListener expirationListener = new CatalinaSessionExpirationListener(context);
        IdentifierFactoryAdapter identifierFactory = new IdentifierFactoryAdapter(this.getSessionIdGenerator());
        SessionManagerConfiguration<ServletContext> sessionManagerConfiguration = new SessionManagerConfiguration<ServletContext>((IdentifierFactory)identifierFactory, (SessionExpirationListener)expirationListener){
            final /* synthetic */ IdentifierFactory val$identifierFactory;
            final /* synthetic */ SessionExpirationListener val$expirationListener;
            {
                this.val$identifierFactory = identifierFactory;
                this.val$expirationListener = sessionExpirationListener;
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }

            public SessionExpirationListener getExpirationListener() {
                return this.val$expirationListener;
            }

            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return null;
            }
        };
        SessionManager sessionManager = this.managerFactory.createSessionManager((SessionManagerConfiguration)sessionManagerConfiguration);
        this.manager = new DistributableManager(sessionManager, context, (Marshallability)marshaller);
        this.manager.start();
        this.setState(LifecycleState.STARTING);
    }

    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        Optional.ofNullable(this.manager).ifPresent(CatalinaManager::stop);
        Optional.ofNullable(this.managerFactory).ifPresent(SessionManagerFactory::close);
        Optional.ofNullable(this.container).ifPresent(Lifecycle::stop);
    }

    public Session createSession(String sessionId) {
        return this.manager.createSession(sessionId);
    }

    public Session findSession(String id) throws IOException {
        return this.manager.findSession(id);
    }

    public void changeSessionId(Session session, String newId) {
        this.manager.changeSessionId(session, newId);
    }

    public boolean willAttributeDistribute(String name, Object value) {
        return this.manager.willAttributeDistribute(name, value);
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void backgroundProcess() {
    }

    public void processExpires() {
        throw new UnsupportedOperationException();
    }

    public void add(Session session) {
        throw new UnsupportedOperationException();
    }

    public Session createEmptySession() {
        throw new UnsupportedOperationException();
    }

    public Session[] findSessions() {
        throw new UnsupportedOperationException();
    }

    public void remove(Session session) {
        throw new UnsupportedOperationException();
    }

    public void remove(Session session, boolean update) {
        throw new UnsupportedOperationException();
    }

    public String listSessionIds() {
        throw new UnsupportedOperationException();
    }

    public String getSessionAttribute(String sessionId, String key) {
        throw new UnsupportedOperationException();
    }

    public HashMap<String, String> getSession(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public void expireSession(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public long getThisAccessedTimestamp(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public String getThisAccessedTime(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public long getLastAccessedTimestamp(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public String getLastAccessedTime(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public String getCreationTime(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public long getCreationTimestamp(String sessionId) {
        throw new UnsupportedOperationException();
    }
}

